/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.kodi.KodiScraperProcessor;
import org.tinymediamanager.scraper.kodi.KodiUrl;
import org.tinymediamanager.scraper.util.UrlUtil;

class KodiAddonProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiAddonProcessor.class);
    public static final String FUNCTION_SETTINGS = "GetSettings";
    public static final String FUNCTION_NFO_URL = "NfoUrl";
    public static final String FUNCTION_CREATE_SEARCH_URL = "CreateSearchUrl";
    public static final String FUNCTION_GET_SEARCH_RESULTS = "GetSearchResults";
    public static final String FUNCTION_GET_DETAILS = "GetDetails";
    private static final String FUNCTION_GET_EPISODE_LIST = "GetEpisodeList";
    private static final String FUNCTION_GET_EPISODE_DETAILS = "GetEpisodeDetails";
    private KodiScraperProcessor scraperProcessor;

    public KodiAddonProcessor(KodiScraper scraper) {
        this.scraperProcessor = new KodiScraperProcessor(scraper);
    }

    public KodiUrl getNfoUrl(String nfoContents) throws Exception {
        String url = null;
        if (this.scraperProcessor.containsFunction(FUNCTION_NFO_URL)) {
            url = this.scraperProcessor.executeFunction(FUNCTION_NFO_URL, new String[]{"", nfoContents});
        }
        if (!StringUtils.isEmpty(url)) {
            return new KodiUrl(url);
        }
        return null;
    }

    public KodiUrl getSearchUrl(String title, String date) throws Exception {
        String url;
        if (date == null) {
            date = "";
        }
        if (!StringUtils.isEmpty((CharSequence)(url = this.scraperProcessor.executeFunction(FUNCTION_CREATE_SEARCH_URL, new String[]{"", UrlUtil.encode((String)title), URLEncoder.encode(date, "UTF-8")})))) {
            return new KodiUrl(url);
        }
        return null;
    }

    public String getSearchResults(KodiUrl url) throws Exception {
        String contents = url.getTextContent();
        return this.scraperProcessor.executeFunction(FUNCTION_GET_SEARCH_RESULTS, new String[]{"", contents, url.toExternalForm()});
    }

    public String getDefaultSettings() {
        return this.scraperProcessor.executeFunction(FUNCTION_SETTINGS, null);
    }

    public String getDetails(KodiUrl url, String id) throws Exception {
        String contents = url.getTextContent();
        String movieId = id;
        if (StringUtils.isEmpty((CharSequence)movieId)) {
            LOGGER.debug("getDetails() called with empty id.");
            movieId = this.parseIdFromUrl(url.toExternalForm());
        }
        LOGGER.debug("getDetails() called with id: " + movieId + " and url: " + url.toExternalForm());
        return this.scraperProcessor.executeFunction(FUNCTION_GET_DETAILS, new String[]{"", contents, movieId, url.toExternalForm()});
    }

    private String parseIdFromUrl(String url) {
        Matcher m;
        Pattern p2;
        String movieId = null;
        try {
            p2 = Pattern.compile("/(tt[0-9]+)/");
            m = p2.matcher(url);
            if (m.find()) {
                movieId = m.group(1);
                LOGGER.debug("Setting IMDB ID: " + movieId);
            }
        }
        catch (Exception p2) {
            // empty catch block
        }
        if (StringUtils.isEmpty(movieId)) {
            try {
                p2 = Pattern.compile("http://www.themoviedb.org/movie/([0-9]+)\\-");
                m = p2.matcher(url);
                if (m.find()) {
                    movieId = m.group(1);
                    LOGGER.debug("Setting TMDB ID: " + movieId);
                }
            }
            catch (Exception p3) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty(movieId)) {
            try {
                p2 = Pattern.compile("http://www.thetvdb.com/api/(.*?)/series/([0-9]*)/all");
                m = p2.matcher(url);
                if (m.find()) {
                    movieId = m.group(2);
                    LOGGER.debug("Setting TVDB ID: " + movieId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return movieId;
    }

    public String getEpisodeList(KodiUrl url) throws Exception {
        String contents = url.getTextContent();
        return this.scraperProcessor.executeFunction(FUNCTION_GET_EPISODE_LIST, new String[]{"", contents, url.toExternalForm()});
    }

    public String getEpisodeDetails(KodiUrl url, String id) throws Exception {
        String contents = url.getTextContent();
        return this.scraperProcessor.executeFunction(FUNCTION_GET_EPISODE_DETAILS, new String[]{"", contents, id});
    }
}

