/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import net.xeoh.plugins.base.annotations.events.Init;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiUtil;
import org.tinymediamanager.scraper.mediaprovider.IKodiMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.scraper.util.CacheMap;

@PluginImplementation
public class KodiMetadataProvider
implements IKodiMetadataProvider {
    private static MediaProviderInfo providerInfo = new MediaProviderInfo("kodi", "kodi.tv", "Generic Kodi type scraper");
    protected static final CacheMap<String, String> XML_CACHE = new CacheMap(3600L, 60L);

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    @Init
    public void init() {
        new KodiUtil();
    }

    public List<IMediaProvider> getPluginsForType(MediaType type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IMediaProvider> metadataProviders = new ArrayList<IMediaProvider>();
        for (AbstractKodiMetadataProvider metadataProvider : KodiUtil.scrapers) {
            if (type != metadataProvider.scraper.type) continue;
            metadataProviders.add((IMediaProvider)metadataProvider);
        }
        return metadataProviders;
    }
}

