/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.kodi.AbstractKodiMetadataProvider;
import org.tinymediamanager.scraper.kodi.KodiScraper;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.w3c.dom.Document;

public class KodiMovieMetadataProvider
extends AbstractKodiMetadataProvider
implements IMovieMetadataProvider,
IMovieArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiMovieMetadataProvider.class);

    public KodiMovieMetadataProvider(KodiScraper scraper) {
        super(scraper);
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("Kodi: getMetadata(): " + options);
        if (options.getResult() == null || !this.scraper.getProviderInfo().getId().equals(options.getResult().getProviderId())) {
            throw new MissingIdException(new String[]{"scraping with Kodi scrapers only with a prior result possible"});
        }
        return this._getMetadata(options);
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException {
        return this._search(options);
    }

    @Override
    protected void processXmlContent(String xmlDetails, MediaMetadata md, MediaSearchResult result) throws Exception {
        if (xmlDetails == null || StringUtils.isEmpty((CharSequence)xmlDetails)) {
            LOGGER.warn("Cannot process empty Xml Contents.");
            return;
        }
        LOGGER.debug("******* BEGIN XML ***********");
        LOGGER.debug(xmlDetails);
        LOGGER.debug("******* END XML ***********");
        Document xml = this.parseXmlString(xmlDetails);
        this.addMetadata(md, xml.getDocumentElement());
        LOGGER.debug("MetaData: " + md.toString());
    }

    public List<IMediaProvider> getPluginsForType(MediaType type) {
        return null;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions arg0) throws ScrapeException {
        LOGGER.debug("******* BEGIN ARTWORK XML FOR " + arg0.getArtworkType() + " ***********");
        ArrayList<MediaArtwork> mas = new ArrayList<MediaArtwork>();
        try {
            MediaMetadata md = this.getMetadata(arg0);
            mas.addAll(md.getMediaArt(arg0.getArtworkType()));
            LOGGER.debug("******* END ARTWORK XML FOR " + arg0.getArtworkType() + " ***********");
        }
        catch (Exception e) {
            LOGGER.error("problem getting artwork: " + e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        return mas;
    }
}

