/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.kodi;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.kodi.Expression;
import org.tinymediamanager.scraper.kodi.RegExpContainer;

class RegExp
implements RegExpContainer,
Cloneable {
    private String input;
    private String output;
    private int dest;
    private String conditional;
    private boolean appendBuffer = false;
    private List<RegExp> children = new ArrayList<RegExp>();
    private Expression expression;

    public RegExp clone() {
        RegExp c = new RegExp();
        c.input = this.input;
        c.output = this.output;
        c.dest = this.dest;
        c.conditional = this.conditional;
        c.appendBuffer = this.appendBuffer;
        c.expression = this.expression;
        for (RegExp r : this.children) {
            c.addRegExp(r.clone());
        }
        return c;
    }

    @Override
    public void addRegExp(RegExp regexp) {
        this.children.add(regexp);
    }

    @Override
    public RegExp[] getRegExps() {
        return this.children.toArray(new RegExp[this.children.size()]);
    }

    @Override
    public boolean hasRegExps() {
        return this.children != null && this.children.size() > 0;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public int getDest() {
        return this.dest;
    }

    public void setInput(String input) {
        if (StringUtils.isEmpty((CharSequence)input)) {
            input = "$$1";
        }
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setDest(int dest) {
        this.dest = dest;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isAppendBuffer() {
        return this.appendBuffer;
    }

    public void setAppendBuffer(boolean appendBuffer) {
        this.appendBuffer = appendBuffer;
    }

    public String getConditional() {
        return this.conditional;
    }

    public void setConditional(String conditional) {
        this.conditional = conditional;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

