/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.enumerations;

import java.util.HashMap;
import java.util.Map;

public enum CreditType {
    CAST("cast"),
    CREW("crew");

    private static final Map<String, CreditType> lookup;
    private final String value;

    private static Map<String, CreditType> prepareLookup() {
        HashMap<String, CreditType> ctMap = new HashMap<String, CreditType>();
        for (CreditType creditType : CreditType.values()) {
            ctMap.put(creditType.value, creditType);
        }
        return ctMap;
    }

    public static CreditType get(String value) {
        return lookup.get(value);
    }

    private CreditType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    static {
        lookup = CreditType.prepareLookup();
    }
}

