/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.enumerations;

import java.util.HashMap;
import java.util.Map;

public enum MediaType {
    MOVIE("movie"),
    TV("tv"),
    PERSON("person");

    private static final Map<String, MediaType> lookup;
    private final String value;

    private static Map<String, MediaType> prepareLookup() {
        HashMap<String, MediaType> mtMap = new HashMap<String, MediaType>();
        for (MediaType mediaType : MediaType.values()) {
            mtMap.put(mediaType.value, mediaType);
        }
        return mtMap;
    }

    public static MediaType get(String value) {
        return lookup.get(value);
    }

    private MediaType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    static {
        lookup = MediaType.prepareLookup();
    }
}

