/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.BaseCompany;
import com.uwetrottmann.tmdb2.entities.BaseKeyword;
import com.uwetrottmann.tmdb2.entities.BaseMovie;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.Country;
import com.uwetrottmann.tmdb2.entities.CrewMember;
import com.uwetrottmann.tmdb2.entities.FindResults;
import com.uwetrottmann.tmdb2.entities.Genre;
import com.uwetrottmann.tmdb2.entities.Movie;
import com.uwetrottmann.tmdb2.entities.MovieResultsPage;
import com.uwetrottmann.tmdb2.entities.ReleaseDate;
import com.uwetrottmann.tmdb2.entities.ReleaseDatesResult;
import com.uwetrottmann.tmdb2.entities.SpokenLanguage;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import com.uwetrottmann.tmdb2.enumerations.ExternalSource;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

class TmdbMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieMetadataProvider.class);
    private final Tmdb api;

    TmdbMovieMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException {
        Exception savedException = null;
        LOGGER.debug("search() " + options.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        searchString = MetadataUtil.removeNonSearchCharacters((String)searchString);
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = "";
        }
        if (MetadataUtil.isValidImdbId((String)searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        Integer year = null;
        if (options.getYear() > 1800) {
            year = options.getYear();
        }
        boolean adult = TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("includeAdult");
        String language = options.getLanguage().toLanguageTag();
        LOGGER.info("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            Response httpResponse;
            if (tmdbId != 0) {
                LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
                try {
                    httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    Iterator movie = (Movie)httpResponse.body();
                    this.verifyMovieTitleLanguage(options.getLanguage(), (Movie)((Object)movie));
                    MediaSearchResult result = this.morphMovieToSearchResult((BaseMovie)((Object)movie));
                    resultList.add(result);
                    LOGGER.debug("found {} results with TMDB id", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (resultList.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
                LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
                try {
                    httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseMovie movie : ((FindResults)httpResponse.body()).movie_results) {
                        this.verifyMovieTitleLanguage(options.getLanguage(), movie);
                        resultList.add(this.morphMovieToSearchResult(movie));
                    }
                    LOGGER.debug("found " + resultList.size() + " results with IMDB id");
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (resultList.isEmpty()) {
                try {
                    httpResponse = this.api.searchService().movie(searchString, 1, language, adult, year, year, "phrase").execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseMovie movie : ((MovieResultsPage)httpResponse.body()).results) {
                        this.verifyMovieTitleLanguage(options.getLanguage(), movie);
                        resultList.add(this.morphMovieToSearchResult(movie));
                    }
                    LOGGER.debug("found {} results with search string", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (resultList.isEmpty()) {
                searchString = searchString.replaceFirst("\\s\\d{4}$", "");
                try {
                    MovieResultsPage resultsPage = (MovieResultsPage)this.api.searchService().movie(searchString, 1, language, adult, null, null, "phrase").execute().body();
                    if (resultsPage != null && resultsPage.results != null) {
                        for (BaseMovie movie : resultsPage.results) {
                            this.verifyMovieTitleLanguage(options.getLanguage(), movie);
                            resultList.add(this.morphMovieToSearchResult(movie));
                        }
                    }
                    LOGGER.debug("found {} results with search string without year", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
        }
        if (resultList.isEmpty() && savedException != null) {
            throw new ScrapeException((Throwable)savedException);
        }
        if (resultList.isEmpty()) {
            return resultList;
        }
        for (MediaSearchResult result : resultList) {
            if (StringUtils.isNotBlank((CharSequence)imdbId) && imdbId.equals(result.getIMDBId()) || String.valueOf(tmdbId).equals(result.getId())) {
                LOGGER.debug("perfect match by ID - set score to 1");
                result.setScore(1.0f);
                continue;
            }
            float score = Math.max(MetadataUtil.calculateScore((String)searchString, (String)result.getTitle()), MetadataUtil.calculateScore((String)searchString, (String)result.getOriginalTitle()));
            if (year != null && this.yearDiffers(year, result.getYear())) {
                float diff = (float)Math.abs(year - result.getYear()) / 100.0f;
                LOGGER.debug("parsed year does not match search result year - downgrading score by {}", (Object)Float.valueOf(diff));
                score -= diff;
            }
            if (result.getPosterUrl() == null || result.getPosterUrl().isEmpty()) {
                LOGGER.debug("no poster - downgrading score by 0.01");
                score -= 0.01f;
            }
            result.setScore(score);
        }
        return resultList;
    }

    private void verifyMovieTitleLanguage(Locale language, Movie movie) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue() || StringUtils.isEmpty((CharSequence)movie.overview)) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (movie.title.equals(movie.original_title) && !movie.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {} for movie {}", (Object)fallbackLanguage, (Object)movie.title);
                String[] val = TmdbMetadataProvider.getValuesFromTranslation(movie.translations, language);
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(movie.translations, fallbackLanguage);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                temp = TmdbMetadataProvider.getValuesFromTranslation(movie.translations, Locale.US);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                if (val[0].isEmpty()) {
                    val[0] = movie.title;
                }
                if (val[1].isEmpty()) {
                    val[1] = movie.overview;
                }
                movie.title = val[0];
                movie.overview = val[1];
            }
        }
    }

    private void verifyMovieTitleLanguage(Locale language, BaseMovie movie) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue()) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (movie.title.equals(movie.original_title) && !movie.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {} for movie {}", (Object)fallbackLanguage, (Object)movie.title);
                String lang = TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.moviesService().summary(movie.id, lang, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Movie m = (Movie)httpResponse.body();
                String[] val = TmdbMetadataProvider.getValuesFromTranslation(m.translations, language);
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(m.translations, fallbackLanguage);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                temp = TmdbMetadataProvider.getValuesFromTranslation(m.translations, Locale.US);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                if (val[0].isEmpty()) {
                    val[0] = m.title;
                }
                if (val[1].isEmpty()) {
                    val[1] = m.overview;
                }
                movie.title = val[0];
                movie.overview = val[1];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Exception savedException = null;
        LOGGER.debug("getMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && !MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException(new String[]{"tmdb", "imdb"});
        }
        String language = options.getLanguage().toLanguageTag();
        Movie movie = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            if (tmdbId == 0 && MetadataUtil.isValidImdbId((String)imdbId)) {
                try {
                    tmdbId = new TmdbMetadataProvider().getTmdbIdFromImdbId(imdbId, options.getType());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (movie == null && tmdbId > 0) {
                try {
                    Response httpResponse = this.api.moviesService().summary(tmdbId, language, new AppendToResponse(AppendToResponseItem.CREDITS, AppendToResponseItem.KEYWORDS, AppendToResponseItem.RELEASE_DATES, AppendToResponseItem.TRANSLATIONS)).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    movie = (Movie)httpResponse.body();
                    this.verifyMovieTitleLanguage(options.getLanguage(), movie);
                }
                catch (TmdbNotFoundException e) {
                    LOGGER.info("nothing found");
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: " + e.getMessage());
                    savedException = e;
                }
            }
        }
        if (movie == null && savedException != null) {
            throw new ScrapeException((Throwable)savedException);
        }
        if (movie == null) {
            LOGGER.warn("no result found");
            throw new NothingFoundException();
        }
        md = this.morphMovieToMediaMetadata(movie, options);
        if (movie.keywords != null && movie.keywords.keywords != null) {
            for (BaseKeyword kw : movie.keywords.keywords) {
                md.addTag(kw.name);
            }
        }
        return md;
    }

    private MediaSearchResult morphMovieToSearchResult(BaseMovie movie) {
        MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE);
        searchResult.setId(Integer.toString(movie.id));
        searchResult.setTitle(movie.title);
        searchResult.setOverview(movie.overview);
        searchResult.setOriginalTitle(movie.original_title);
        searchResult.setOriginalLanguage(movie.original_language);
        if (movie.poster_path != null && !movie.poster_path.isEmpty()) {
            searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
        }
        if (movie.release_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(movie.release_date);
            searchResult.setYear(calendar.get(1));
        }
        return searchResult;
    }

    private MediaMetadata morphMovieToMediaMetadata(Movie movie, MediaScrapeOptions options) {
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)movie.id);
        md.setTitle(movie.title);
        md.setOriginalTitle(movie.original_title);
        md.setPlot(movie.overview);
        md.setTagline(movie.tagline);
        md.setRuntime(movie.runtime);
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(movie.vote_average.doubleValue());
        rating.setVoteCount(movie.vote_count.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        if (StringUtils.isNotBlank((CharSequence)movie.poster_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + movie.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(movie.id.intValue());
            md.addMediaArt(ma);
        }
        for (SpokenLanguage lang : ListUtils.nullSafe(movie.spoken_languages)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString((Locale)options.getLanguage(), (String[])new String[]{lang.name, lang.iso_639_1}));
                continue;
            }
            md.addSpokenLanguage(lang.iso_639_1);
        }
        for (Country country : ListUtils.nullSafe(movie.production_countries)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((Locale)options.getLanguage(), (String[])new String[]{country.name, country.iso_3166_1}));
                continue;
            }
            md.addCountry(country.iso_3166_1);
        }
        if (MetadataUtil.isValidImdbId((String)movie.imdb_id)) {
            md.setId("imdb", (Object)movie.imdb_id);
        }
        for (BaseCompany company : ListUtils.nullSafe(movie.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        Date releaseDate = movie.release_date;
        if (releaseDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(releaseDate);
            md.setYear(calendar.get(1));
        }
        md.setReleaseDate(releaseDate);
        if (movie.release_dates != null) {
            for (ReleaseDatesResult countries : ListUtils.nullSafe(movie.release_dates.results)) {
                if (options.getCountry() != null && options.getCountry().getAlpha2().compareToIgnoreCase(countries.iso_3166_1) != 0) continue;
                for (ReleaseDate countryReleaseDate : ListUtils.nullSafe(countries.release_dates)) {
                    if (StringUtils.isEmpty((CharSequence)countryReleaseDate.certification)) continue;
                    md.addCertification(Certification.getCertification((String)countries.iso_3166_1, (String)countryReleaseDate.certification));
                }
            }
        }
        if (movie.credits != null) {
            MediaCastMember cm;
            for (CastMember castMember : ListUtils.nullSafe(movie.credits.cast)) {
                cm = new MediaCastMember();
                cm.setType(MediaCastMember.CastType.ACTOR);
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)castMember.id);
                cm.setCharacter(castMember.character);
                cm.setName(castMember.name);
                if (!StringUtils.isEmpty((CharSequence)castMember.profile_path)) {
                    cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
                }
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(movie.credits.crew)) {
                cm = new MediaCastMember();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(MediaCastMember.CastType.DIRECTOR);
                    cm.setPart(crewMember.department);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(MediaCastMember.CastType.WRITER);
                    cm.setPart(crewMember.department);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(MediaCastMember.CastType.PRODUCER);
                    cm.setPart(crewMember.job);
                }
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)crewMember.id);
                cm.setName(crewMember.name);
                if (!StringUtils.isEmpty((CharSequence)crewMember.profile_path)) {
                    cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                md.addCastMember(cm);
            }
        }
        for (Genre genre : ListUtils.nullSafe((Iterable)movie.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        if (movie.adult.booleanValue()) {
            md.addGenre(MediaGenres.EROTIC);
        }
        if (movie.belongs_to_collection != null) {
            md.setId("tmdbSet", (Object)movie.belongs_to_collection.id);
            md.setCollectionName(movie.belongs_to_collection.name);
        }
        return md;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }
}

