/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.BaseCompany;
import com.uwetrottmann.tmdb2.entities.BaseTvEpisode;
import com.uwetrottmann.tmdb2.entities.BaseTvShow;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.ContentRating;
import com.uwetrottmann.tmdb2.entities.CrewMember;
import com.uwetrottmann.tmdb2.entities.FindResults;
import com.uwetrottmann.tmdb2.entities.Genre;
import com.uwetrottmann.tmdb2.entities.TvEpisode;
import com.uwetrottmann.tmdb2.entities.TvSeason;
import com.uwetrottmann.tmdb2.entities.TvShow;
import com.uwetrottmann.tmdb2.entities.TvShowResultsPage;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import com.uwetrottmann.tmdb2.enumerations.ExternalSource;
import com.uwetrottmann.tmdb2.exceptions.TmdbNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

class TmdbTvShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private final Tmdb api;

    TmdbTvShowMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException {
        Exception savedException = null;
        LOGGER.debug("search() " + options.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        searchString = MetadataUtil.removeNonSearchCharacters((String)searchString);
        String imdbId = options.getImdbId();
        if (!MetadataUtil.isValidImdbId((String)imdbId)) {
            imdbId = "";
        }
        if (MetadataUtil.isValidImdbId((String)searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        Integer year = null;
        if (options.getYear() != 0) {
            year = options.getYear();
        }
        String language = options.getLanguage().toLanguageTag();
        LOGGER.info("========= BEGIN TMDB Scraper Search for: " + searchString);
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            Response httpResponse;
            if (tmdbId != 0) {
                LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
                try {
                    httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    TvShow show = (TvShow)httpResponse.body();
                    this.verifyTvShowLanguageTitle(options.getLanguage(), show);
                    resultList.add(this.morphTvShowToSearchResult(show, options));
                    LOGGER.debug("found {} results with TMDB id", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (resultList.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
                LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
                try {
                    httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                        this.verifyTvShowLanguageTitle(options.getLanguage(), show);
                        resultList.add(this.morphTvShowToSearchResult(show, options));
                    }
                    LOGGER.debug("found {} results with IMDB id", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
            if (resultList.isEmpty()) {
                try {
                    httpResponse = this.api.searchService().tv(searchString, 1, language, year, "phrase").execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    for (BaseTvShow show : ListUtils.nullSafe((Iterable)((TvShowResultsPage)httpResponse.body()).results)) {
                        this.verifyTvShowLanguageTitle(options.getLanguage(), show);
                        resultList.add(this.morphTvShowToSearchResult(show, options));
                    }
                    LOGGER.debug("found {} results with search string", (Object)resultList.size());
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data from tmdb: {}", (Object)e.getMessage());
                    savedException = e;
                }
            }
        }
        if (resultList.isEmpty() && savedException != null) {
            throw new ScrapeException((Throwable)savedException);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList() " + options.toString());
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0) {
            throw new MissingIdException(new String[]{"tmdb"});
        }
        String language = options.getLanguage().toLanguageTag();
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response showResponse = this.api.tvService().tv(tmdbId, language).execute();
                if (!showResponse.isSuccessful()) {
                    throw new HttpException(showResponse.code(), showResponse.message());
                }
                for (TvSeason season : ListUtils.nullSafe(((TvShow)showResponse.body()).seasons)) {
                    ArrayList<MediaMetadata> seasonEpisodes = new ArrayList<MediaMetadata>();
                    Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, season.season_number, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                    if (!seasonResponse.isSuccessful()) {
                        throw new HttpException(seasonResponse.code(), seasonResponse.message());
                    }
                    for (TvEpisode episode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                        seasonEpisodes.add(this.morphTvEpisodeToMediaMetadata(episode));
                    }
                    episodes.addAll(seasonEpisodes);
                }
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        return episodes;
    }

    MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException, UnsupportedMediaTypeException {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("getTvShowMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && MetadataUtil.isValidImdbId((String)imdbId)) {
            tmdbId = this.getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException(new String[]{"tmdb", "imdb"});
        }
        String language = options.getLanguage().toLanguageTag();
        TvShow complete = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                complete = (TvShow)httpResponse.body();
                this.verifyTvShowLanguageTitle(options.getLanguage(), complete);
            }
            catch (TmdbNotFoundException e) {
                LOGGER.info("nothing found");
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)tmdbId);
        md.setTitle(complete.name);
        md.setOriginalTitle(complete.original_name);
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(complete.vote_average.doubleValue());
        rating.setVoteCount(complete.vote_count.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        for (Object country : ListUtils.nullSafe((Iterable)complete.origin_country)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((Locale)options.getLanguage(), (String[])new String[]{country}));
                continue;
            }
            md.addCountry((String)country);
        }
        if (complete.episode_run_time != null && !complete.episode_run_time.isEmpty()) {
            md.setRuntime(complete.episode_run_time.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + complete.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + complete.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(complete.id.intValue());
            md.addMediaArt(ma);
        }
        for (BaseCompany company : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(complete.credits.cast)) {
                MediaCastMember cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                cm.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)castMember.id);
                cm.setName(castMember.name);
                cm.setCharacter(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (!StringUtils.isEmpty((CharSequence)castMember.profile_path)) {
                    cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
        }
        if (complete.external_ids != null) {
            if (complete.external_ids.tvdb_id != null && complete.external_ids.tvdb_id > 0) {
                md.setId("tvdb", (Object)complete.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)complete.external_ids.imdb_id)) {
                md.setId("imdb", (Object)complete.external_ids.imdb_id);
            }
            if (complete.external_ids.tvrage_id != null && complete.external_ids.tvrage_id > 0) {
                md.setId("tvrage", (Object)complete.external_ids.tvrage_id);
            }
        }
        if (complete.content_ratings != null) {
            for (Object country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (options.getCountry() != null && options.getCountry().getAlpha2().compareToIgnoreCase(((ContentRating)country).iso_3166_1) != 0 || StringUtils.isEmpty((CharSequence)((ContentRating)country).rating)) continue;
                md.addCertification(Certification.getCertification((String)((ContentRating)country).iso_3166_1, (String)((ContentRating)country).rating));
            }
        }
        for (Genre genre : ListUtils.nullSafe(complete.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaCastMember cm;
        LOGGER.debug("getEpisodeMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && MetadataUtil.isValidImdbId((String)imdbId)) {
            tmdbId = this.getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException(new String[]{"tmdb", "imdb"});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (seasonNr == -1 || episodeNr == -1) {
            LOGGER.warn("season number/episode number found");
            throw new MissingIdException(new String[]{"seasonNr", "episodeNr"});
        }
        String language = options.getLanguage().toLanguageTag();
        TvEpisode episode = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            try {
                Response httpResponse = this.api.tvSeasonsService().season(tmdbId, seasonNr, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvSeason fullSeason = (TvSeason)httpResponse.body();
                for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                    if (ep.season_number != seasonNr || ep.episode_number != episodeNr) continue;
                    episode = ep;
                    break;
                }
                if (episode == null && !aired.isEmpty()) {
                    for (TvEpisode ep : ListUtils.nullSafe(fullSeason.episodes)) {
                        SimpleDateFormat formatter;
                        String epAired;
                        if (ep.air_date == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)ep.air_date)).equals(aired)) continue;
                        episode = ep;
                        break;
                    }
                }
                this.verifyTvEpisodeTitleLanguage(episode, options);
            }
            catch (TmdbNotFoundException e) {
                LOGGER.info("nothing found");
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        if (episode == null) {
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.episode_number}));
        md.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.season_number}));
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)episode.id);
        if (episode.external_ids != null) {
            if (episode.external_ids.tvdb_id != null && episode.external_ids.tvdb_id > 0) {
                md.setId("tvdb", (Object)episode.external_ids.tvdb_id);
            }
            if (StringUtils.isNotBlank((CharSequence)episode.external_ids.imdb_id)) {
                md.setId("imdb", (Object)episode.external_ids.imdb_id);
            }
            if (episode.external_ids.tvrage_id != null && episode.external_ids.tvrage_id > 0) {
                md.setId("tvrage", (Object)episode.external_ids.tvrage_id);
            }
        }
        md.setTitle(episode.name);
        md.setPlot(episode.overview);
        MediaRating rating = new MediaRating("tmdb");
        rating.setRating(episode.vote_average.doubleValue());
        rating.setVoteCount(episode.vote_count.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        md.setReleaseDate(episode.air_date);
        for (CastMember castMember : ListUtils.nullSafe(episode.guest_stars)) {
            cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            cm.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)castMember.id);
            cm.setName(castMember.name);
            cm.setCharacter(castMember.character);
            if (castMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
            }
            if (!StringUtils.isEmpty((CharSequence)castMember.profile_path)) {
                cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + castMember.profile_path);
            }
            md.addCastMember(cm);
        }
        for (CrewMember crewMember : ListUtils.nullSafe(episode.crew)) {
            cm = new MediaCastMember();
            if ("Director".equals(crewMember.job)) {
                cm.setType(MediaCastMember.CastType.DIRECTOR);
                cm.setPart(crewMember.department);
            } else if ("Writing".equals(crewMember.department)) {
                cm.setType(MediaCastMember.CastType.WRITER);
                cm.setPart(crewMember.department);
            } else {
                if (!"Production".equals(crewMember.department)) continue;
                cm.setType(MediaCastMember.CastType.PRODUCER);
                cm.setPart(crewMember.job);
            }
            cm.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)crewMember.id);
            cm.setName(crewMember.name);
            if (!StringUtils.isEmpty((CharSequence)crewMember.profile_path)) {
                cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "h632" + crewMember.profile_path);
            }
            if (crewMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
            }
            md.addCastMember(cm);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.still_path) && (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.THUMB)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "original" + episode.still_path);
            md.addMediaArt(ma);
        }
        return md;
    }

    private int getTmdbIdFromImdbId(String imdbId) {
        try {
            FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
            if (findResults != null) {
                if (findResults.tv_results != null && !findResults.tv_results.isEmpty()) {
                    return findResults.tv_results.get((int)0).id;
                }
                if (findResults.tv_episode_results != null && !findResults.tv_episode_results.isEmpty()) {
                    return findResults.tv_episode_results.get((int)0).id;
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get tmdb id: " + e.getMessage());
        }
        return 0;
    }

    private void verifyTvShowLanguageTitle(Locale language, TvShow show) {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue() || StringUtils.isEmpty((CharSequence)show.overview)) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String[] val = TmdbMetadataProvider.getValuesFromTranslation(show.translations, language);
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(show.translations, fallbackLanguage);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                temp = TmdbMetadataProvider.getValuesFromTranslation(show.translations, Locale.US);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                if (val[0].isEmpty()) {
                    val[0] = show.name;
                }
                if (val[1].isEmpty()) {
                    val[1] = show.overview;
                }
                show.name = val[0];
                show.overview = val[1];
            }
        }
    }

    private void verifyTvShowLanguageTitle(Locale language, BaseTvShow show) throws IOException {
        if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue()) {
            Locale fallbackLanguage = Locale.forLanguageTag(TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String lang = TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.tvService().tv(show.id, lang, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvShow s = (TvShow)httpResponse.body();
                String[] val = TmdbMetadataProvider.getValuesFromTranslation(s.translations, language);
                String[] temp = TmdbMetadataProvider.getValuesFromTranslation(s.translations, fallbackLanguage);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                temp = TmdbMetadataProvider.getValuesFromTranslation(s.translations, Locale.US);
                if (val[0].isEmpty()) {
                    val[0] = temp[0];
                }
                if (val[1].isEmpty()) {
                    val[1] = temp[1];
                }
                if (val[0].isEmpty()) {
                    val[0] = s.name;
                }
                if (val[1].isEmpty()) {
                    val[1] = s.overview;
                }
                show.name = val[0];
                show.overview = val[1];
            }
        }
    }

    private void verifyTvEpisodeTitleLanguage(BaseTvEpisode episode, MediaScrapeOptions query) {
        int seasonNr = query.getIdAsInt("seasonNr");
        int episodeNr = query.getIdAsInt("episodeNr");
        if (episode != null && (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{episode.name, episode.overview}) || this.isEpisodesNameDefault(episode, episodeNr).booleanValue() || TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("titleFallback").booleanValue())) {
            String languageFallback = MediaLanguages.get((String)TmdbMetadataProvider.providerInfo.getConfig().getValue("titleFallbackLanguage")).name().replace("_", "-");
            try {
                TvEpisode ep = (TvEpisode)this.api.tvEpisodesService().episode(query.getTmdbId(), episode.season_number, episode.episode_number, languageFallback).execute().body();
                if (ep != null && (ep.season_number == seasonNr || ep.episode_number.equals(episode.season_number)) && (ep.episode_number == episodeNr || ep.episode_number.equals(episode.episode_number))) {
                    if (StringUtils.isBlank((CharSequence)episode.name) || this.isEpisodesNameDefault(episode, episodeNr).booleanValue() && !this.isEpisodesNameDefault(ep, episodeNr).booleanValue()) {
                        episode.name = ep.name;
                    }
                    if (StringUtils.isBlank((CharSequence)episode.overview)) {
                        episode.overview = ep.overview;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Integer toInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private Boolean isEpisodesNameDefault(BaseTvEpisode episode, Integer episodeNr) {
        Integer potentialEpisodeNumber;
        String[] originalEpisodeName = episode.name.split(" ");
        return originalEpisodeName.length == 2 && (potentialEpisodeNumber = this.toInteger(originalEpisodeName[1])) != null && (potentialEpisodeNumber.equals(episode.episode_number) || potentialEpisodeNumber.equals(episodeNr));
    }

    private MediaMetadata morphTvEpisodeToMediaMetadata(BaseTvEpisode episode) {
        MediaMetadata ep = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        ep.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)episode.id);
        ep.setEpisodeNumber(episode.episode_number);
        ep.setSeasonNumber(episode.season_number);
        ep.setTitle(episode.name);
        ep.setPlot(episode.overview);
        if (episode.vote_average != null && episode.vote_count != null) {
            MediaRating rating = new MediaRating(TmdbMetadataProvider.providerInfo.getId());
            rating.setRating(episode.vote_average.doubleValue());
            rating.setVoteCount(episode.vote_count.intValue());
            rating.setMaxValue(10);
            ep.addRating(rating);
        }
        if (episode.air_date != null) {
            ep.setReleaseDate(episode.air_date);
        }
        return ep;
    }

    private MediaSearchResult morphTvShowToSearchResult(BaseTvShow tvShow, MediaSearchOptions query) {
        MediaSearchResult result = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.TV_SHOW);
        result.setId(Integer.toString(tvShow.id));
        result.setTitle(tvShow.name);
        result.setOriginalTitle(tvShow.original_name);
        result.setOverview(tvShow.overview);
        if (tvShow.poster_path != null && !tvShow.poster_path.isEmpty()) {
            result.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + tvShow.poster_path);
        }
        if (tvShow.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tvShow.first_air_date);
            result.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(result.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(result.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            result.setScore(1.0f);
        } else {
            float score = Math.max(MetadataUtil.calculateScore((String)query.getQuery(), (String)result.getTitle()), MetadataUtil.calculateScore((String)query.getQuery(), (String)result.getOriginalTitle()));
            if (query.getYear() > 0 && this.yearDiffers(query.getYear(), result.getYear())) {
                float diff = (float)Math.abs(query.getYear() - result.getYear()) / 100.0f;
                LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                score -= diff;
            }
            if (result.getPosterUrl() == null || result.getPosterUrl().isEmpty()) {
                LOGGER.debug("no poster - downgrading score by 0.01");
                score -= 0.01f;
            }
            result.setScore(score);
        }
        return result;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 > 0 && i2 > 0 && i1 != i2;
    }
}

