/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.MetadataUtil;

public class MediaScrapeOptions {
    private MediaSearchResult result;
    private MediaMetadata metadata;
    private Map<String, Object> ids = new HashMap<String, Object>();
    private MediaType type;
    private MediaArtwork.MediaArtworkType artworkType = MediaArtwork.MediaArtworkType.ALL;
    private Locale language = Locale.getDefault();
    private CountryCode country = CountryCode.getDefault();
    private MediaArtwork.FanartSizes fanartSize = MediaArtwork.FanartSizes.MEDIUM;
    private MediaArtwork.PosterSizes posterSize = MediaArtwork.PosterSizes.MEDIUM;

    public MediaScrapeOptions(MediaType type) {
        this.type = type;
    }

    public MediaSearchResult getResult() {
        return this.result;
    }

    public void setResult(MediaSearchResult result) {
        this.result = result;
    }

    public String getIdAsString(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            return String.valueOf(id);
        }
        if (this.result != null) {
            return this.result.getIdAsString(providerId);
        }
        return null;
    }

    public Integer getIdAsInteger(String providerId) {
        Object id = this.ids.get(providerId);
        if (id != null) {
            if (id instanceof Integer) {
                return (Integer)id;
            }
            if (id instanceof String) {
                try {
                    return Integer.parseInt((String)id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.result != null) {
            return this.result.getIdAsInt(providerId);
        }
        return null;
    }

    public int getIdAsInt(String providerId) {
        return this.getIdAsIntOrDefault(providerId, 0);
    }

    public int getIdAsIntOrDefault(String providerId, int defaultValue) {
        Integer id = this.getIdAsInteger(providerId);
        if (id == null) {
            return defaultValue;
        }
        return id;
    }

    public void setId(String providerId, String id) {
        this.ids.put(providerId, id);
    }

    public String getImdbId() {
        String imdbId = "";
        Object obj = this.ids.get("imdb");
        if (obj != null) {
            imdbId = obj.toString();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && (obj = this.ids.get("imdbId")) != null) {
            imdbId = obj.toString();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && this.result != null) {
            imdbId = this.result.getIMDBId();
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }

    public int getTmdbId() {
        int id = this.getIdAsInt("tmdb");
        if (id == 0) {
            id = this.getIdAsIntOrDefault("tmdbId", 0);
        }
        if (id == 0 && this.result != null) {
            id = this.result.getIdAsInt("tmdb");
        }
        return id;
    }

    public void setImdbId(String imdbId) {
        this.ids.put("imdb", imdbId);
    }

    public void setTmdbId(int tmdbId) {
        this.ids.put("tmdb", tmdbId);
    }

    public MediaArtwork.MediaArtworkType getArtworkType() {
        return this.artworkType;
    }

    public void setArtworkType(MediaArtwork.MediaArtworkType artworkType) {
        this.artworkType = artworkType;
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MediaMetadata metadata) {
        this.metadata = metadata;
    }

    public MediaType getType() {
        return this.type;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public CountryCode getCountry() {
        return this.country;
    }

    public void setCountry(CountryCode country) {
        this.country = country;
    }

    public MediaArtwork.FanartSizes getFanartSize() {
        return this.fanartSize;
    }

    public MediaArtwork.PosterSizes getPosterSize() {
        return this.posterSize;
    }

    public void setFanartSize(MediaArtwork.FanartSizes fanartSize) {
        this.fanartSize = fanartSize;
    }

    public void setPosterSize(MediaArtwork.PosterSizes posterSize) {
        this.posterSize = posterSize;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("metadata");
            }
        }.toString();
    }
}

