/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaSearchResult
implements Comparable<MediaSearchResult> {
    private String providerId;
    private String url;
    private String title;
    private String overview;
    private int year;
    private String originalTitle;
    private String originalLanguage;
    private Map<String, Object> ids = new HashMap<String, Object>();
    private float score;
    private MediaMetadata metadata = null;
    private MediaType type;
    private String posterUrl;

    public MediaSearchResult(String providerId, MediaType type) {
        this.providerId = providerId;
        this.type = type;
    }

    public MediaSearchResult(String providerId, MediaType type, float score) {
        this.providerId = providerId;
        this.type = type;
        this.score = score;
    }

    public MediaSearchResult(String providerId, MediaType type, String id, String title, int year, float score) {
        this.providerId = providerId;
        this.type = type;
        this.ids.put(providerId, StrgUtils.getNonNullString(id));
        this.title = StrgUtils.getNonNullString(title);
        this.year = year;
        this.score = score;
    }

    public void mergeFrom(MediaSearchResult msr) {
        if (msr == null) {
            return;
        }
        this.url = StringUtils.isEmpty((CharSequence)this.url) ? msr.getUrl() : this.url;
        this.title = StringUtils.isEmpty((CharSequence)this.title) ? msr.getTitle() : this.title;
        this.year = this.year == 0 ? msr.getYear() : this.year;
        this.originalTitle = StringUtils.isEmpty((CharSequence)this.originalTitle) ? msr.getOriginalTitle() : this.originalTitle;
        this.originalLanguage = StringUtils.isEmpty((CharSequence)this.originalLanguage) ? msr.getOriginalLanguage() : this.originalLanguage;
        this.posterUrl = StringUtils.isEmpty((CharSequence)this.posterUrl) ? msr.getPosterUrl() : this.posterUrl;
        for (String key : msr.getIds().keySet()) {
            if (this.ids.containsKey(key)) continue;
            this.ids.put(key, msr.getIds().get(key));
        }
        if (this.metadata == null) {
            this.metadata = msr.getMediaMetadata();
        } else {
            this.metadata.mergeFrom(msr.getMediaMetadata());
        }
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = StrgUtils.getNonNullString(originalTitle);
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public void setOriginalLanguage(String originalLanguage) {
        this.originalLanguage = StrgUtils.getNonNullString(originalLanguage);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = StrgUtils.getNonNullString(title);
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setYear(Integer year) {
        if (year != null) {
            this.setYear((int)year);
        }
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public void setScore(Float score) {
        if (score != null) {
            this.setScore(score.floatValue());
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = StrgUtils.getNonNullString(url);
    }

    public MediaType getMediaType() {
        return this.type;
    }

    public Object getId() {
        return this.ids.get(this.providerId);
    }

    public void setId(String id) {
        this.ids.put(this.providerId, StrgUtils.getNonNullString(id));
    }

    public void setId(String providerId, String id) {
        this.ids.put(providerId, StrgUtils.getNonNullString(id));
    }

    public String getIMDBId() {
        String imdbId = "";
        Object obj = this.ids.get("imdb");
        if (obj != null) {
            imdbId = obj.toString();
        }
        if (!MetadataUtil.isValidImdbId(imdbId) && (obj = this.ids.get("imdbId")) != null) {
            imdbId = obj.toString();
        }
        if (StringUtils.isBlank((CharSequence)imdbId)) {
            return "";
        }
        return imdbId;
    }

    public int getIdAsInt(String key) {
        int id = 0;
        try {
            id = Integer.parseInt(String.valueOf(this.ids.get(key)));
        }
        catch (Exception e) {
            return 0;
        }
        return id;
    }

    public String getIdAsString(String key) {
        Object obj = this.ids.get(key);
        if (obj == null) {
            return "";
        }
        return String.valueOf(obj);
    }

    public Map<String, Object> getIds() {
        return this.ids;
    }

    public void setIMDBId(String imdbid) {
        if (MetadataUtil.isValidImdbId(imdbid)) {
            this.ids.put("imdb", imdbid);
        }
    }

    public MediaMetadata getMediaMetadata() {
        return this.metadata;
    }

    public void setMetadata(MediaMetadata md) {
        this.metadata = md;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String posterUrl) {
        this.posterUrl = StrgUtils.getNonNullString(posterUrl);
    }

    @Override
    public int compareTo(MediaSearchResult arg0) {
        if (this.getScore() < arg0.getScore()) {
            return -1;
        }
        if (this.getScore() == arg0.getScore()) {
            return Integer.compare(this.getYear(), arg0.getYear());
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaSearchResult other = (MediaSearchResult)obj;
        if (this.type != other.type) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("metadata");
            }
        }.toString();
    }
}

