/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.xeoh.plugins.base.impl.PluginManagerFactory;
import net.xeoh.plugins.base.options.AddPluginsFromOption;
import net.xeoh.plugins.base.util.JSPFProperties;
import net.xeoh.plugins.base.util.PluginManagerUtil;
import net.xeoh.plugins.base.util.uri.ClassURI;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;

public class PluginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private static net.xeoh.plugins.base.PluginManager pm;
    private static PluginManagerUtil pmu;
    private static PluginManager instance;

    public static synchronized PluginManager getInstance() {
        if (instance == null) {
            JSPFProperties props = new JSPFProperties();
            props.setProperty(net.xeoh.plugins.base.PluginManager.class, "cache.enabled", "true");
            props.setProperty(net.xeoh.plugins.base.PluginManager.class, "cache.mode", "weak");
            props.setProperty(net.xeoh.plugins.base.PluginManager.class, "cache.file", "jspf.cache");
            instance = new PluginManager();
            pm = PluginManagerFactory.createPluginManager((Properties)props);
            pmu = new PluginManagerUtil(pm);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            LOGGER.debug("loading external plugins...");
            pm.addPluginsFrom(Paths.get("plugins/", new String[0]).toUri(), new AddPluginsFromOption[0]);
            stopWatch.stop();
            LOGGER.debug("Done loading external plugins - took " + stopWatch);
        }
        return instance;
    }

    public void loadClasspathPlugins() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        LOGGER.debug("loading classpath plugins...");
        pm.addPluginsFrom(ClassURI.CLASSPATH((String)"org.tinymediamanager.scraper.**"), new AddPluginsFromOption[0]);
        stopWatch.stop();
        LOGGER.debug("Done loading classpath plugins - took " + stopWatch);
    }

    public void afterInitialization() {
        for (IMediaProvider p : this.getPluginsForInterface(IMediaProvider.class)) {
            p.afterInitialization();
            LOGGER.trace("loaded plugin: {}", (Object)p.getClass().getName());
        }
    }

    public <T extends IMediaProvider> List<T> getPluginsForInterface(Class<T> iface) {
        ArrayList<IMediaProvider> plugins = new ArrayList<IMediaProvider>();
        for (IMediaProvider mp : pmu.getPlugins(iface)) {
            plugins.add(mp);
        }
        return plugins;
    }
}

