/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.util.StrgUtils;

public class SubtitleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtitleUtils.class);
    private static final int HASH_CHUNK_SIZE = 65536;

    private SubtitleUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeSubDBHash(File file) {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            MappedByteBuffer head = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, chunkSizeForFile);
            MappedByteBuffer tail = fileChannel.map(FileChannel.MapMode.READ_ONLY, Math.max(size - 65536L, 0L), chunkSizeForFile);
            byte[] hbytes = new byte[head.remaining()];
            ((ByteBuffer)head).duplicate().get(hbytes);
            byte[] tbytes = new byte[tail.remaining()];
            ((ByteBuffer)tail).duplicate().get(tbytes);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(hbytes);
            md.update(tbytes);
            String string = StrgUtils.bytesToHex(md.digest());
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error computing SubDB hash", (Throwable)e);
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing file stream", (Throwable)e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String computeOpenSubtitlesHash(File file) {
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        FileChannel fileChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            long head = SubtitleUtils.computeOpenSubtitlesHashForChunk(fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, chunkSizeForFile));
            long tail = SubtitleUtils.computeOpenSubtitlesHashForChunk(fileChannel.map(FileChannel.MapMode.READ_ONLY, Math.max(size - 65536L, 0L), chunkSizeForFile));
            String string = String.format("%016x", size + head + tail);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Error computing OpenSubtitles hash", (Throwable)e);
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing file stream", (Throwable)e);
            }
        }
        return "";
    }

    private static long computeOpenSubtitlesHashForChunk(ByteBuffer buffer) {
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }
}

