/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.util;

import java.io.Serializable;

public class Pager
implements Serializable {
    private Long numOfRecords = 0L;
    private Integer page = 1;
    private Long pageSize = 15L;

    public Pager() {
    }

    public Pager(Long numOfRecords) {
        this.numOfRecords = numOfRecords;
    }

    public Pager(Long numOfRecords, Integer page) {
        this.numOfRecords = numOfRecords;
        this.page = page;
    }

    public Pager(Long numOfRecords, Integer page, Long pageSize) {
        this.numOfRecords = numOfRecords;
        this.page = page;
        this.pageSize = pageSize;
    }

    public Long getNumOfRecords() {
        return this.numOfRecords;
    }

    public void setNumOfRecords(Long numOfRecords) {
        this.numOfRecords = numOfRecords;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        if (page != null) {
            this.page = page;
        }
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Long pageSize) {
        if (pageSize != null) {
            this.pageSize = pageSize;
        }
    }

    public int getNextPage() {
        return this.page + 1;
    }

    public int getPreviousPage() {
        return this.page - 1;
    }

    public int getFirstPage() {
        return 1;
    }

    public long getIndexRangeBegin() {
        long retval = (long)(this.getPage() - 1) * this.getPageSize();
        return Math.max(Math.min(this.getNumOfRecords() - 1L, retval >= 0L ? retval : 0L), 0L);
    }

    public long getIndexRangeEnd() {
        long firstIndex = this.getIndexRangeBegin();
        long pageIndex = this.getPageSize() - 1L;
        long lastIndex = this.getNumOfRecords() - 1L;
        return Math.min(firstIndex + pageIndex, lastIndex);
    }

    public long getLastPage() {
        long lastPage = this.numOfRecords / this.pageSize;
        if (this.numOfRecords % this.pageSize == 0L) {
            --lastPage;
        }
        return lastPage + 1L;
    }

    public boolean isPreviousPageAvailable() {
        return this.getIndexRangeBegin() + 1L > this.getPageSize();
    }

    public boolean isNextPageAvailable() {
        return this.numOfRecords - 1L > this.getIndexRangeEnd();
    }

    public boolean isSeveralPages() {
        return this.getNumOfRecords() != 0L && this.getNumOfRecords() > this.getPageSize();
    }

    public String toString() {
        return "Pager - Records: " + this.getNumOfRecords() + " Page size: " + this.getPageSize();
    }
}

