/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public abstract class AbstractToolBarUI
extends BasicToolBarUI {
    private static final String IS_ROLLOVER = "JToolBar.isRollover";
    private static final Insets BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private static final Border INNER_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private boolean rolloverEnabled = true;
    private MyPropertyChangeListener propertyChangeListener = null;
    private MyContainerListener containerListener = null;
    private final Hashtable orgBorders = new Hashtable();
    private final Hashtable orgMargins = new Hashtable();

    public abstract Border getRolloverBorder();

    public abstract Border getNonRolloverBorder();

    public abstract boolean isButtonOpaque();

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        Boolean isRollover = (Boolean)UIManager.get(IS_ROLLOVER);
        if (isRollover != null) {
            this.rolloverEnabled = isRollover;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractToolBarUI.this.changeBorders();
            }
        });
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.restoreBorders();
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new MyPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.containerListener = new MyContainerListener();
        if (this.containerListener != null) {
            this.toolBar.addContainerListener(this.containerListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.propertyChangeListener = null;
        if (this.containerListener != null) {
            this.toolBar.removeContainerListener(this.containerListener);
        }
        this.containerListener = null;
        super.uninstallListeners();
    }

    protected boolean isRolloverEnabled() {
        return this.rolloverEnabled;
    }

    @Override
    protected void setBorderToNormal(Component c) {
    }

    @Override
    protected void setBorderToRollover(Component c) {
    }

    @Override
    protected void setBorderToNonRollover(Component c) {
    }

    protected void changeBorders() {
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (!(comp instanceof AbstractButton)) continue;
            this.changeButtonBorder((AbstractButton)comp);
        }
    }

    protected void restoreBorders() {
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component comp = components[i];
            if (!(comp instanceof AbstractButton)) continue;
            this.restoreButtonBorder((AbstractButton)comp);
        }
    }

    protected void changeButtonBorder(AbstractButton b) {
        Boolean changeBorder;
        Object cp = b.getClientProperty("paintToolBarBorder");
        if (cp != null && cp instanceof Boolean && !(changeBorder = (Boolean)cp).booleanValue()) {
            return;
        }
        if (!this.orgBorders.contains(b)) {
            if (b.getBorder() != null) {
                this.orgBorders.put(b, b.getBorder());
            } else {
                this.orgBorders.put(b, new NullBorder());
            }
        }
        if (!this.orgMargins.contains(b)) {
            this.orgMargins.put(b, b.getMargin());
        }
        if (b.getBorder() != null) {
            if (this.isRolloverEnabled()) {
                b.setBorderPainted(true);
                b.setBorder(BorderFactory.createCompoundBorder(this.getRolloverBorder(), INNER_BORDER));
                b.setMargin(BUTTON_MARGIN);
                b.setRolloverEnabled(true);
                b.setOpaque(this.isButtonOpaque());
                b.setContentAreaFilled(this.isButtonOpaque());
            } else {
                b.setBorder(BorderFactory.createCompoundBorder(this.getNonRolloverBorder(), INNER_BORDER));
                b.setMargin(BUTTON_MARGIN);
                b.setRolloverEnabled(false);
                b.setOpaque(this.isButtonOpaque());
                b.setContentAreaFilled(this.isButtonOpaque());
            }
        }
    }

    protected void restoreButtonBorder(AbstractButton b) {
        Boolean changeBorder;
        Object cp = b.getClientProperty("paintToolBarBorder");
        if (cp != null && cp instanceof Boolean && !(changeBorder = (Boolean)cp).booleanValue()) {
            return;
        }
        Border border = (Border)this.orgBorders.get(b);
        if (border != null) {
            if (border instanceof NullBorder) {
                b.setBorder(null);
            } else {
                b.setBorder(border);
            }
        }
        b.setMargin((Insets)this.orgMargins.get(b));
    }

    protected void updateToolbarBorder() {
        this.toolBar.revalidate();
        this.toolBar.repaint();
    }

    protected boolean isToolBarUnderMenubar() {
        JRootPane rp;
        JMenuBar mb;
        if (this.toolBar != null && this.toolBar.getOrientation() == 0 && (mb = (rp = SwingUtilities.getRootPane(this.toolBar)).getJMenuBar()) != null) {
            Point mbPoint = new Point(0, 0);
            mbPoint = SwingUtilities.convertPoint(mb, mbPoint, rp);
            Point tbPoint = new Point(0, 0);
            tbPoint = SwingUtilities.convertPoint(this.toolBar, tbPoint, rp);
            tbPoint.y -= mb.getHeight() - 1;
            Rectangle rect = new Rectangle(mbPoint, mb.getSize());
            return rect.contains(tbPoint);
        }
        return false;
    }

    protected boolean isToolbarDecorated() {
        return AbstractLookAndFeel.getTheme().isToolbarDecorated();
    }

    private static class NullBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(0, 0, 0, 0);

        private NullBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    protected class MyContainerListener
    implements ContainerListener {
        protected MyContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof AbstractButton) {
                AbstractToolBarUI.this.changeButtonBorder((AbstractButton)c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof AbstractButton) {
                AbstractToolBarUI.this.restoreButtonBorder((AbstractButton)c);
            }
        }
    }

    protected class MyPropertyChangeListener
    implements PropertyChangeListener {
        protected MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(AbstractToolBarUI.IS_ROLLOVER)) {
                if (e.getNewValue() != null) {
                    AbstractToolBarUI.this.rolloverEnabled = (Boolean)e.getNewValue();
                    AbstractToolBarUI.this.changeBorders();
                }
            } else if ("componentOrientation".equals(e.getPropertyName())) {
                AbstractToolBarUI.this.updateToolbarBorder();
            }
        }
    }
}

