/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BaseSplitPaneDivider
extends BasicSplitPaneDivider {
    protected boolean centerOneTouchButtons = true;
    protected boolean flatMode = false;

    public BaseSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        if (JTattooUtilities.getJavaVersion() >= 1.4 && UIManager.get("SplitPane.centerOneTouchButtons") != null) {
            this.centerOneTouchButtons = UIManager.getBoolean("SplitPane.centerOneTouchButtons");
        }
        this.setLayout(new MyDividerLayout());
        Object flatModeProperty = ui.getSplitPane().getClientProperty("flatMode");
        if (flatModeProperty instanceof Boolean) {
            this.flatMode = (Boolean)flatModeProperty;
        }
    }

    public boolean isFlatMode() {
        return this.flatMode;
    }

    public void setFlatMode(boolean flatMode) {
        this.flatMode = flatMode;
    }

    @Override
    public Border getBorder() {
        return null;
    }

    public Color getRolloverColor() {
        return ColorHelper.darker(AbstractLookAndFeel.getTheme().getRolloverColor(), 16.0);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.isFlatMode()) {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            int width = this.getSize().width;
            int height = this.getSize().height;
            int dx = 0;
            int dy = 0;
            if (width % 2 == 1) {
                dx = 1;
            }
            if (height % 2 == 1) {
                dy = 1;
            }
            ColorUIResource color = AbstractLookAndFeel.getBackgroundColor();
            Color cHi = ColorHelper.brighter(color, 25.0);
            Color cLo = ColorHelper.darker(color, 5.0);
            Color[] colors = ColorHelper.createColorArr(cHi, cLo, 10);
            if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                if (this.orientation == 1) {
                    JTattooUtilities.fillVerGradient(g, colors, 0, 0, width, height);
                    Icon horBumps = laf.getIconFactory().getSplitterHorBumpIcon();
                    if (horBumps != null && width > horBumps.getIconWidth()) {
                        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.7f);
                        g2D.setComposite(alpha);
                        if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                            int centerY = height / 2;
                            int x = (width - horBumps.getIconWidth()) / 2 + dx;
                            int y = centerY - horBumps.getIconHeight() - 40;
                            horBumps.paintIcon(this, g, x, y);
                            y = centerY + 40;
                            horBumps.paintIcon(this, g, x, y);
                        } else {
                            int x = (width - horBumps.getIconWidth()) / 2 + dx;
                            int y = (height - horBumps.getIconHeight()) / 2;
                            horBumps.paintIcon(this, g, x, y);
                        }
                    }
                } else {
                    JTattooUtilities.fillHorGradient(g, colors, 0, 0, width, height);
                    Icon verBumps = laf.getIconFactory().getSplitterVerBumpIcon();
                    if (verBumps != null && height > verBumps.getIconHeight()) {
                        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.7f);
                        g2D.setComposite(alpha);
                        if (this.splitPane.isOneTouchExpandable() && this.centerOneTouchButtons) {
                            int centerX = width / 2;
                            int x = centerX - verBumps.getIconWidth() - 40;
                            int y = (height - verBumps.getIconHeight()) / 2 + dy;
                            verBumps.paintIcon(this, g, x, y);
                            x = centerX + 40;
                            verBumps.paintIcon(this, g, x, y);
                        } else {
                            int x = (width - verBumps.getIconWidth()) / 2;
                            int y = (height - verBumps.getIconHeight()) / 2 + dy;
                            verBumps.paintIcon(this, g, x, y);
                        }
                    }
                }
            }
            g2D.setComposite(savedComposite);
        }
        this.paintComponents(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void paint(Graphics g) {
                Color color = this.getBackground();
                int w = this.getSize().width;
                int h = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    g.setColor(ColorHelper.darker(color, 40.0));
                    g.fillRect(0, 0, w, h);
                } else if (this.getModel().isRollover()) {
                    g.setColor(BaseSplitPaneDivider.this.getRolloverColor());
                    g.fillRect(0, 0, w, h);
                }
                if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                    AbstractLookAndFeel lf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                    Icon icon = BaseSplitPaneDivider.this.orientation == 1 ? lf.getIconFactory().getSplitterLeftArrowIcon() : lf.getIconFactory().getSplitterUpArrowIcon();
                    int x = (w - icon.getIconWidth()) / 2;
                    int y = (h - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g, x, y);
                }
                if (this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(g, ColorHelper.darker(color, 30.0), ColorHelper.brighter(color, 80.0), 0, 0, w, h);
                    } else {
                        JTattooUtilities.draw3DBorder(g, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 30.0), 0, 0, w, h);
                    }
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setRolloverEnabled(true);
        return b;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        JButton b = new JButton(){

            @Override
            public void paint(Graphics g) {
                Color color = this.getBackground();
                int w = this.getSize().width;
                int h = this.getSize().height;
                if (this.getModel().isPressed() && this.getModel().isArmed()) {
                    g.setColor(ColorHelper.darker(color, 40.0));
                    g.fillRect(0, 0, w, h);
                } else if (this.getModel().isRollover()) {
                    g.setColor(BaseSplitPaneDivider.this.getRolloverColor());
                    g.fillRect(0, 0, w, h);
                }
                if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
                    AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
                    Icon icon = BaseSplitPaneDivider.this.orientation == 1 ? laf.getIconFactory().getSplitterRightArrowIcon() : laf.getIconFactory().getSplitterDownArrowIcon();
                    int x = (w - icon.getIconWidth()) / 2;
                    int y = (h - icon.getIconHeight()) / 2;
                    icon.paintIcon(this, g, x, y);
                }
                if (this.getModel().isArmed()) {
                    if (this.getModel().isPressed()) {
                        JTattooUtilities.draw3DBorder(g, ColorHelper.darker(color, 30.0), ColorHelper.brighter(color, 80.0), 0, 0, w, h);
                    } else {
                        JTattooUtilities.draw3DBorder(g, ColorHelper.brighter(color, 80.0), ColorHelper.darker(color, 30.0), 0, 0, w, h);
                    }
                }
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        b.setCursor(Cursor.getPredefinedCursor(0));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setContentAreaFilled(false);
        b.setRolloverEnabled(true);
        return b;
    }

    protected class MyDividerLayout
    implements LayoutManager {
        protected MyDividerLayout() {
        }

        @Override
        public void layoutContainer(Container c) {
            if (BaseSplitPaneDivider.this.leftButton != null && BaseSplitPaneDivider.this.rightButton != null && c == BaseSplitPaneDivider.this) {
                if (BaseSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BaseSplitPaneDivider.this.getInsets();
                    int blockSize = 11;
                    int xOffs = 0;
                    int yOffs = 0;
                    if (BaseSplitPaneDivider.this.centerOneTouchButtons) {
                        blockSize = 13;
                        xOffs = (BaseSplitPaneDivider.this.getWidth() - 2 * blockSize) / 2 - blockSize;
                        yOffs = (BaseSplitPaneDivider.this.getHeight() - 2 * blockSize) / 2 - blockSize;
                    }
                    if (BaseSplitPaneDivider.this.orientation == 0) {
                        int extraX;
                        int n = extraX = insets != null ? insets.left : 0;
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        int y = (c.getSize().height - blockSize) / 2;
                        BaseSplitPaneDivider.this.leftButton.setBounds(xOffs + extraX, y, blockSize * 2, blockSize);
                        BaseSplitPaneDivider.this.rightButton.setBounds(xOffs + extraX + blockSize * 2 + 1, y, blockSize * 2, blockSize);
                    } else {
                        int extraY;
                        int n = extraY = insets != null ? insets.top : 0;
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        int x = (c.getSize().width - blockSize) / 2;
                        BaseSplitPaneDivider.this.leftButton.setBounds(x, yOffs + extraY, blockSize, blockSize * 2);
                        BaseSplitPaneDivider.this.rightButton.setBounds(x, yOffs + extraY + blockSize * 2 + 1, blockSize, blockSize * 2);
                    }
                } else {
                    BaseSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BaseSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width;
            if (c != BaseSplitPaneDivider.this || BaseSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension buttonMinSize = null;
            if (BaseSplitPaneDivider.this.splitPane.isOneTouchExpandable() && BaseSplitPaneDivider.this.leftButton != null) {
                buttonMinSize = BaseSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = BaseSplitPaneDivider.this.getInsets();
            int height = width = BaseSplitPaneDivider.this.getDividerSize();
            if (BaseSplitPaneDivider.this.orientation == 0) {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.height;
                    if (insets != null) {
                        size += insets.top + insets.bottom;
                    }
                    height = Math.max(height, size);
                }
                width = 1;
            } else {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.width;
                    if (insets != null) {
                        size += insets.left + insets.right;
                    }
                    width = Math.max(width, size);
                }
                height = 1;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }
}

