/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class DecorationHelper {
    private DecorationHelper() {
    }

    public static void decorateWindows(Boolean decorate) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class[] classParams = new Class[]{Boolean.TYPE};
                Method m = JFrame.class.getMethod("setDefaultLookAndFeelDecorated", classParams);
                Object[] methodParams = new Object[]{decorate};
                m.invoke(null, methodParams);
                m = JDialog.class.getMethod("setDefaultLookAndFeelDecorated", classParams);
                m.invoke(null, methodParams);
                System.setProperty("sun.awt.noerasebackground", "true");
                System.setProperty("sun.awt.erasebackgroundonresize", "false");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getWindowDecorationStyle(JRootPane root) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class<?>[] paramTypes = null;
                Object[] args = null;
                Method m = root.getClass().getMethod("getWindowDecorationStyle", paramTypes);
                Integer i = (Integer)m.invoke((Object)root, args);
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getExtendedState(Frame frame) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class<?>[] paramTypes = null;
                Object[] args = null;
                Method m = frame.getClass().getMethod("getExtendedState", paramTypes);
                Integer i = (Integer)m.invoke((Object)frame, args);
                return i;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void setExtendedState(Frame frame, int state) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class[] classParams = new Class[]{Integer.TYPE};
                Method m = frame.getClass().getMethod("setExtendedState", classParams);
                Object[] methodParams = new Object[]{new Integer(state)};
                m.invoke((Object)frame, methodParams);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean isFrameStateSupported(Toolkit tk, int state) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            try {
                Class[] classParams = new Class[]{Integer.TYPE};
                Method m = tk.getClass().getMethod("isFrameStateSupported", classParams);
                Object[] methodParams = new Object[]{new Integer(state)};
                Boolean b = (Boolean)m.invoke((Object)tk, methodParams);
                return b;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isTranslucentWindowSupported() {
        return JTattooUtilities.getJavaVersion() >= 1.601 && (JTattooUtilities.isMac() || JTattooUtilities.isWindows());
    }

    public static void setTranslucentWindow(Window wnd, boolean translucent) {
        if (DecorationHelper.isTranslucentWindowSupported()) {
            if (JTattooUtilities.getJavaVersion() >= 1.7) {
                if (translucent) {
                    if (wnd.getBackground() == null || !wnd.getBackground().equals(new Color(0, 0, 0, 0))) {
                        wnd.setBackground(new Color(0, 0, 0, 0));
                    }
                } else if (wnd.getBackground() == null || !wnd.getBackground().equals(new Color(0, 0, 0, 255))) {
                    wnd.setBackground(new Color(0, 0, 0, 255));
                }
            } else if (JTattooUtilities.getJavaVersion() >= 1.601) {
                try {
                    Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                    Class[] classParams = new Class[]{Window.class, Boolean.TYPE};
                    Method method = clazz.getMethod("setWindowOpaque", classParams);
                    if (translucent) {
                        Object[] methodParams = new Object[]{wnd, Boolean.FALSE};
                        method.invoke((Object)wnd, methodParams);
                    } else {
                        Object[] methodParams = new Object[]{wnd, Boolean.TRUE};
                        method.invoke((Object)wnd, methodParams);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

