/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;

public class TmmScrollBarUI
extends BasicScrollBarUI {
    protected static int SCROLL_BAR_WIDTH = 16;
    protected static int TRACK_WIDTH = 8;
    protected static int GAP = 4;
    protected boolean swapColors;

    public static ComponentUI createUI(JComponent c) {
        return new TmmScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Object swapColors = this.scrollbar.getClientProperty("swapColors");
        this.swapColors = swapColors != null && "true".equals(swapColors.toString());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(SCROLL_BAR_WIDTH, SCROLL_BAR_WIDTH * 2 + 16);
        }
        return new Dimension(SCROLL_BAR_WIDTH * 2 + 16, SCROLL_BAR_WIDTH);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(TRACK_WIDTH - 2, SCROLL_BAR_WIDTH * 2);
        }
        return new Dimension(SCROLL_BAR_WIDTH * 2, TRACK_WIDTH - 2);
    }

    @Override
    protected Dimension getMaximumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(TRACK_WIDTH - 2, SCROLL_BAR_WIDTH * 3);
        }
        return new Dimension(SCROLL_BAR_WIDTH * 3, TRACK_WIDTH - 2);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createZeroButton();
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createZeroButton();
    }

    protected JButton createZeroButton() {
        JButton button = new JButton("zero button");
        Dimension zeroDim = new Dimension(0, 0);
        button.setPreferredSize(zeroDim);
        button.setMinimumSize(zeroDim);
        button.setMaximumSize(zeroDim);
        return button;
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        super.layoutVScrollbar(sb);
        if (sb.getValue() == 0) {
            this.thumbRect.setBounds(this.thumbRect.x, -1 + GAP, this.thumbRect.width, this.thumbRect.height - 2 * GAP);
        } else {
            this.thumbRect.setBounds(this.thumbRect.x, this.thumbRect.y + GAP, this.thumbRect.width, this.thumbRect.height - 2 * GAP);
        }
        this.trackRect.setBounds(this.trackRect.x, this.trackRect.y + GAP, this.trackRect.width, this.trackRect.height - 2 * GAP);
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        super.layoutHScrollbar(sb);
        this.trackRect.setBounds(this.trackRect.x + GAP, this.trackRect.y, this.trackRect.width - 2 * GAP, this.trackRect.height);
        this.thumbRect.setBounds(this.thumbRect.x + GAP, this.thumbRect.y, this.thumbRect.width - 2 * GAP, this.thumbRect.height);
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        if (this.getThumbBounds().isEmpty()) {
            return;
        }
        if (this.scrollbar.isOpaque()) {
            if (this.swapColors) {
                c.setBackground(AbstractLookAndFeel.getTheme().getTrackColors()[0]);
                g.setColor(AbstractLookAndFeel.getTheme().getBackgroundColorDark());
            } else {
                c.setBackground(AbstractLookAndFeel.getTheme().getBackgroundColor());
                g.setColor(AbstractLookAndFeel.getTheme().getTrackColors()[0]);
            }
        }
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.scrollbar.getOrientation() == 1) {
            int x = (SCROLL_BAR_WIDTH - TRACK_WIDTH) / 2;
            g.fillRoundRect(trackBounds.x + x, trackBounds.y, TRACK_WIDTH, trackBounds.height, TRACK_WIDTH, TRACK_WIDTH);
        } else {
            int y = (SCROLL_BAR_WIDTH - TRACK_WIDTH) / 2;
            g.fillRoundRect(trackBounds.x, trackBounds.y + y, trackBounds.width, TRACK_WIDTH, TRACK_WIDTH, TRACK_WIDTH);
        }
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        g.translate(thumbBounds.x, thumbBounds.y);
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.swapColors) {
            g.setColor(AbstractLookAndFeel.getTheme().getTrackColors()[0]);
        } else {
            g.setColor(AbstractLookAndFeel.getTheme().getThumbColors()[0]);
        }
        if (this.scrollbar.getOrientation() == 1) {
            int x = (SCROLL_BAR_WIDTH - TRACK_WIDTH) / 2;
            g.fillRoundRect(x + 1, 2, TRACK_WIDTH - 2, thumbBounds.height - 4, TRACK_WIDTH - 2, TRACK_WIDTH - 2);
        } else {
            int y = (SCROLL_BAR_WIDTH - TRACK_WIDTH) / 2;
            g.fillRoundRect(2, y + 1, thumbBounds.width - 4, TRACK_WIDTH - 2, TRACK_WIDTH - 2, TRACK_WIDTH - 2);
        }
        g2D.setComposite(savedComposite);
        g2D.setRenderingHints(savedRenderingHints);
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }
}

