/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class TmmTabbedPaneUI
extends BaseTabbedPaneUI {
    protected static int BORDER_RADIUS = 15;
    protected static int DEFAULT_BOTTOM_INSETS = 10 + BORDER_RADIUS;
    private boolean roundEdge = true;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTabbedPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.tabAreaBackground = AbstractLookAndFeel.getTheme().getTabAreaBackgroundColor();
        this.tabInsets = new Insets(5, 20, 5, 20);
        this.tabAreaInsets = new Insets(0, 20, 15, 20);
        this.contentBorderInsets = new Insets(0, 20, DEFAULT_BOTTOM_INSETS, 20);
        this.roundedTabs = false;
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("rightBorder"))) {
            this.tabAreaInsets.right = 0;
            this.contentBorderInsets.right = 0;
        }
        if ("half".equals(this.tabPane.getClientProperty("rightBorder"))) {
            this.tabAreaInsets.right /= 2;
            this.contentBorderInsets.right /= 2;
        }
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("leftBorder"))) {
            this.tabAreaInsets.left = 0;
            this.contentBorderInsets.left = 0;
        }
        if ("half".equals(this.tabPane.getClientProperty("leftBorder"))) {
            this.tabAreaInsets.left /= 2;
            this.contentBorderInsets.left /= 2;
        }
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("roundEdge"))) {
            this.roundEdge = false;
        }
        if (Boolean.FALSE.equals(this.tabPane.getClientProperty("bottomBorder"))) {
            this.contentBorderInsets.bottom = this.roundEdge ? 10 : 0;
        }
        if ("half".equals(this.tabPane.getClientProperty("bottomBorder"))) {
            this.contentBorderInsets.bottom /= 2;
        }
    }

    @Override
    protected Insets getContentBorderInsets(int tabPlacement) {
        return this.contentBorderInsets;
    }

    @Override
    protected Font getTabFont(boolean isSelected) {
        return this.scale(UIManager.getFont("TabbedPane.font").deriveFont(1), 1.1667);
    }

    protected Font scale(Font font, double factor) {
        int newSize = Math.round((float)((double)font.getSize() * factor));
        return font.deriveFont((float)newSize);
    }

    @Override
    protected FontMetrics getFontMetrics() {
        Font font = this.getTabFont(false);
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        RenderingHints savedRenderingHints = g2D.getRenderingHints();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (isSelected) {
            g.setColor(AbstractLookAndFeel.getTheme().getTabSelectionBackgroundColor());
        } else {
            g.setColor(this.tabAreaBackground);
        }
        g.fillRect(x, y, w, h);
        if (isSelected) {
            int[] xPoints = new int[]{x + (w / 2 + 10), x + (w / 2 - 10), x + w / 2};
            int[] yPoints = new int[]{y + h, y + h, y + h + 10};
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        g2D.setRenderingHints(savedRenderingHints);
    }

    @Override
    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Graphics2D g2D = (Graphics2D)g.create();
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int xt = this.contentBorderInsets.left;
        int yt = 0;
        int wt = w - this.contentBorderInsets.left - this.contentBorderInsets.right;
        int ht = h + DEFAULT_BOTTOM_INSETS - this.contentBorderInsets.bottom - BORDER_RADIUS;
        g2D.setColor(AbstractLookAndFeel.getBackgroundColor());
        if (this.roundEdge) {
            g2D.fillRoundRect(xt, yt, wt, ht, BORDER_RADIUS, BORDER_RADIUS);
        } else {
            g2D.fillRect(xt, yt, wt, ht);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTopTabBorder(int tabIndex, Graphics g, int x1, int y1, int x2, int y2, boolean isSelected) {
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        g.setFont(font);
        int mnemIndex = -1;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
        }
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            if (isSelected) {
                g.setColor(AbstractLookAndFeel.getTheme().getTabSelectionForegroundColor());
            } else {
                g.setColor(AbstractLookAndFeel.getTheme().getTabForegroundColor());
            }
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
        }
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle clipRect = g.getClipBounds();
        if (clipRect.y < this.maxTabHeight) {
            g.setColor(this.tabAreaBackground);
            g.fillRect(0, 0, this.tabPane.getWidth(), this.maxTabHeight);
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Rectangle clipRect = g.getClipBounds();
        if (clipRect.y < this.maxTabHeight) {
            g.setColor(this.tabAreaBackground);
            g.fillRect(0, 0, this.tabPane.getWidth(), this.maxTabHeight);
        }
    }
}

