/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.BaseTextPaneUI;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.undo.UndoManager;
import org.tinymediamanager.ui.plaf.RedoAction;
import org.tinymediamanager.ui.plaf.UndoAction;
import org.tinymediamanager.ui.plaf.light.TmmLightBorderFactory;

public class TmmTextPaneUI
extends BaseTextPaneUI {
    private FocusListener focusListener = null;
    private UndoListener undoListener;
    private UndoManager undoManager;
    private UndoAction undoAction;
    private RedoAction redoAction;

    public static ComponentUI createUI(JComponent c) {
        return new TmmTextPaneUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.getComponent().setBorder(TmmLightBorderFactory.getInstance().getTextBorder());
        this.undoManager = new UndoManager();
        this.undoAction = new UndoAction(this.getComponent(), this.undoManager);
        this.redoAction = new RedoAction(this.getComponent(), this.undoManager);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        InputMap im = this.getComponent().getInputMap();
        ActionMap am = this.getComponent().getActionMap();
        am.put("undo", this.undoAction);
        am.put("redo", this.redoAction);
        if (JTattooUtilities.isMac()) {
            int commandKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            im.put(KeyStroke.getKeyStroke(90, commandKey), "undo");
            im.put(KeyStroke.getKeyStroke(89, commandKey), "redo");
        } else {
            im.put(KeyStroke.getKeyStroke(90, 2), "undo");
            im.put(KeyStroke.getKeyStroke(89, 2), "redo");
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (TmmTextPaneUI.this.getComponent() != null) {
                    TmmTextPaneUI.this.getComponent().invalidate();
                    TmmTextPaneUI.this.getComponent().repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (TmmTextPaneUI.this.getComponent() != null) {
                    TmmTextPaneUI.this.getComponent().invalidate();
                    TmmTextPaneUI.this.getComponent().repaint();
                }
            }
        };
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        this.getComponent().getDocument().removeUndoableEditListener(this.undoListener);
        this.undoListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void modelChanged() {
        super.modelChanged();
        if (this.undoListener != null) {
            this.getComponent().getDocument().removeUndoableEditListener(this.undoListener);
        }
        this.undoListener = new UndoListener();
        this.getComponent().getDocument().addUndoableEditListener(this.undoListener);
    }

    private class UndoListener
    implements UndoableEditListener {
        private UndoListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            if (TmmTextPaneUI.this.getComponent().isEditable()) {
                TmmTextPaneUI.this.undoManager.addEdit(e.getEdit());
            }
        }
    }
}

