/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractTheme;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;

public abstract class TmmTheme
extends AbstractTheme {
    public static final String FONT = "Dialog";
    public static final Font FONT_AWESOME = TmmTheme.loadFontAwesome();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font loadFontAwesome() {
        try (InputStream fsAwesome = TmmTheme.class.getResource("fontawesome-pro-regular-400.ttf").openStream();){
            Font font = Font.createFont(0, fsAwesome);
            return font;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        try (InputStream fsRegular = TmmTheme.class.getResource("DejaVuSans.ttf").openStream();
             InputStream fsMono = TmmTheme.class.getResource("DejaVuSansMono.ttf").openStream();){
            Font dejavuRegular = Font.createFont(0, fsRegular);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(dejavuRegular);
            Font dejavuMono = Font.createFont(0, fsMono);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(dejavuMono);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

