/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ViewportUI;
import javax.swing.plaf.basic.BasicViewportUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TmmViewportUI
extends BasicViewportUI {
    private static ViewportUI viewportUI;

    public static ComponentUI createUI(JComponent c) {
        if (viewportUI == null) {
            viewportUI = new TmmViewportUI();
        }
        return viewportUI;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.paintVerticalGridLines(g, c);
        this.paintHorizontalGridLines(g, c);
        super.paint(g, c);
    }

    private void paintVerticalGridLines(Graphics g, JComponent c) {
        JViewport viewport = (JViewport)c;
        int offset = viewport.getViewPosition().x;
        JTable fTable = null;
        if (viewport.getView() instanceof JTable) {
            fTable = (JTable)((JViewport)c).getView();
        }
        if (viewport.getView() instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)viewport.getView();
            fTable = header.getTable();
        }
        if (fTable != null) {
            JScrollPane scrollPane;
            int drawColumnCountOffset = 1;
            if ("RoundScrollPane".equals(viewport.getParent().getClass().getSimpleName()) && (scrollPane = (JScrollPane)viewport.getParent()).getVerticalScrollBar().isShowing()) {
                drawColumnCountOffset = 0;
            }
            ArrayList colsWoRightGrid = new ArrayList();
            if (fTable.getClientProperty("borderNotToDraw") != null) {
                colsWoRightGrid = (ArrayList)fTable.getClientProperty("borderNotToDraw");
            }
            int x = -offset;
            for (int i = 0; i < fTable.getColumnCount() - drawColumnCountOffset; ++i) {
                TableColumn column = fTable.getColumnModel().getColumn(i);
                if (colsWoRightGrid.contains(i) || (x += column.getWidth()) < 0) continue;
                g.setColor(AbstractLookAndFeel.getTheme().getGridColors()[0]);
                g.drawLine(x - 1, g.getClipBounds().y, x - 1, viewport.getHeight());
            }
        }
    }

    private void paintHorizontalGridLines(Graphics g, JComponent c) {
        JViewport viewport = (JViewport)c;
        int offset = viewport.getViewPosition().x;
        JTable fTable = null;
        if (viewport.getView() instanceof JTable) {
            fTable = (JTable)((JViewport)c).getView();
        }
        if (viewport.getView() instanceof JTableHeader) {
            JTableHeader header = (JTableHeader)viewport.getView();
            fTable = header.getTable();
        }
        if (fTable != null) {
            int currentRow;
            Point viewPosition = viewport.getViewPosition();
            g.translate(0, -viewPosition.y);
            int rowAtPoint = fTable.rowAtPoint(g.getClipBounds().getLocation());
            int topY = rowAtPoint < 0 ? g.getClipBounds().y : fTable.getCellRect((int)rowAtPoint, (int)0, (boolean)true).y;
            int n = currentRow = rowAtPoint < 0 ? 0 : rowAtPoint;
            while (topY < g.getClipBounds().y + g.getClipBounds().height) {
                int bottomY = topY + fTable.getRowHeight(currentRow);
                g.setColor(AbstractLookAndFeel.getTheme().getGridColors()[0]);
                g.drawLine(g.getClipBounds().x + 5, bottomY - 1, g.getClipBounds().width, bottomY - 1);
                g.setColor(AbstractLookAndFeel.getTheme().getGridColors()[1]);
                g.drawLine(g.getClipBounds().x + 5, bottomY, g.getClipBounds().width, bottomY);
                topY = bottomY;
                ++currentRow;
            }
            g.translate(0, viewPosition.y);
        }
    }
}

