/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.SampleImpl;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.tracks.CleanInputStream;

public abstract class AbstractH26XTrack
extends AbstractTrack {
    public static int BUFFER = 67107840;
    protected long[] decodingTimes;
    protected List<CompositionTimeToSample.Entry> ctts = new ArrayList<CompositionTimeToSample.Entry>();
    protected List<SampleDependencyTypeBox.Entry> sdtp = new ArrayList<SampleDependencyTypeBox.Entry>();
    protected List<Integer> stss = new ArrayList<Integer>();
    protected TrackMetaData trackMetaData = new TrackMetaData();
    boolean tripleZeroIsEndOfSequence = true;
    private DataSource dataSource;

    public AbstractH26XTrack(DataSource dataSource, boolean tripleZeroIsEndOfSequence) {
        super(dataSource.toString());
        this.dataSource = dataSource;
        this.tripleZeroIsEndOfSequence = tripleZeroIsEndOfSequence;
    }

    public AbstractH26XTrack(DataSource dataSource) {
        this(dataSource, true);
    }

    protected static InputStream cleanBuffer(InputStream is) {
        return new CleanInputStream(is);
    }

    protected static byte[] toArray(ByteBuffer buf) {
        buf = buf.duplicate();
        byte[] b = new byte[buf.remaining()];
        buf.get(b, 0, b.length);
        return b;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    protected ByteBuffer findNextNal(LookAhead la) throws IOException {
        try {
            while (!la.nextThreeEquals001()) {
                la.discardByte();
            }
            la.discardNext3AndMarkStart();
            while (!la.nextThreeEquals000or001orEof(this.tripleZeroIsEndOfSequence)) {
                la.discardByte();
            }
            return la.getNal();
        }
        catch (EOFException e) {
            return null;
        }
    }

    protected abstract SampleEntry getCurrentSampleEntry();

    /*
     * WARNING - void declaration
     */
    protected Sample createSampleObject(List<? extends ByteBuffer> nals) {
        void var5_7;
        byte[] sizeInfo = new byte[nals.size() * 4];
        ByteBuffer sizeBuf = ByteBuffer.wrap(sizeInfo);
        for (ByteBuffer byteBuffer : nals) {
            sizeBuf.putInt(byteBuffer.remaining());
        }
        ByteBuffer[] data = new ByteBuffer[nals.size() * 2];
        boolean bl = false;
        while (var5_7 < nals.size()) {
            data[2 * var5_7] = ByteBuffer.wrap(sizeInfo, (int)(var5_7 * 4), 4);
            data[2 * var5_7 + 1] = nals.get((int)var5_7);
            ++var5_7;
        }
        return new SampleImpl(data, this.getCurrentSampleEntry());
    }

    @Override
    public long[] getSampleDurations() {
        return this.decodingTimes;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return this.ctts;
    }

    @Override
    public long[] getSyncSamples() {
        long[] returns = new long[this.stss.size()];
        for (int i = 0; i < this.stss.size(); ++i) {
            returns[i] = this.stss.get(i).intValue();
        }
        return returns;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return this.sdtp;
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
    }

    public static class LookAhead {
        long bufferStartPos = 0L;
        int inBufferPos = 0;
        DataSource dataSource;
        ByteBuffer buffer;
        long start;

        public LookAhead(DataSource dataSource) throws IOException {
            this.dataSource = dataSource;
            this.fillBuffer();
        }

        public void fillBuffer() throws IOException {
            this.buffer = this.dataSource.map(this.bufferStartPos, Math.min(this.dataSource.size() - this.bufferStartPos, (long)BUFFER));
        }

        public boolean nextThreeEquals001() throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 3) {
                return this.buffer.get(this.inBufferPos) == 0 && this.buffer.get(this.inBufferPos + 1) == 0 && this.buffer.get(this.inBufferPos + 2) == 1;
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 3L >= this.dataSource.size()) {
                throw new EOFException();
            }
            return false;
        }

        public boolean nextThreeEquals000or001orEof(boolean tripleZeroIsEndOfSequence) throws IOException {
            if (this.buffer.limit() - this.inBufferPos >= 3) {
                return this.buffer.get(this.inBufferPos) == 0 && this.buffer.get(this.inBufferPos + 1) == 0 && (this.buffer.get(this.inBufferPos + 2) == 0 && tripleZeroIsEndOfSequence || this.buffer.get(this.inBufferPos + 2) == 1);
            }
            if (this.bufferStartPos + (long)this.inBufferPos + 3L > this.dataSource.size()) {
                return this.bufferStartPos + (long)this.inBufferPos == this.dataSource.size();
            }
            this.bufferStartPos = this.start;
            this.inBufferPos = 0;
            this.fillBuffer();
            return this.nextThreeEquals000or001orEof(tripleZeroIsEndOfSequence);
        }

        public void discardByte() {
            ++this.inBufferPos;
        }

        public void discardNext3AndMarkStart() {
            this.inBufferPos += 3;
            this.start = this.bufferStartPos + (long)this.inBufferPos;
        }

        public ByteBuffer getNal() {
            if (this.start >= this.bufferStartPos) {
                this.buffer.position((int)(this.start - this.bufferStartPos));
                ByteBuffer sample = this.buffer.slice();
                ((Buffer)sample).limit((int)((long)this.inBufferPos - (this.start - this.bufferStartPos)));
                return sample;
            }
            throw new RuntimeException("damn! NAL exceeds buffer");
        }
    }
}

