/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.LinkedList;
import org.mp4parser.Box;
import org.mp4parser.IsoFile;
import org.mp4parser.boxes.iso14496.part12.OriginalFormatBox;
import org.mp4parser.boxes.sampleentry.AudioSampleEntry;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.support.AbstractContainerBox;
import org.mp4parser.tools.ByteBufferByteChannel;
import org.mp4parser.tools.Path;

class CencDecryptingSampleEntryTransformer {
    private HashMap<SampleEntry, SampleEntry> cache = new HashMap();

    CencDecryptingSampleEntryTransformer() {
    }

    SampleEntry transform(SampleEntry se) {
        SampleEntry decSe = this.cache.get(se);
        if (decSe == null) {
            OriginalFormatBox frma;
            if (se.getType().equals("enca")) {
                frma = (OriginalFormatBox)Path.getPath((AbstractContainerBox)((AudioSampleEntry)se), (String)"sinf/frma");
            } else if (se.getType().equals("encv")) {
                frma = (OriginalFormatBox)Path.getPath((AbstractContainerBox)((VisualSampleEntry)se), (String)"sinf/frma");
            } else {
                return se;
            }
            if (frma == null) {
                throw new RuntimeException("Could not find frma box");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                se.getBox(Channels.newChannel(baos));
                decSe = (SampleEntry)new IsoFile((ReadableByteChannel)new ByteBufferByteChannel(ByteBuffer.wrap(baos.toByteArray()))).getBoxes().get(0);
            }
            catch (IOException e) {
                throw new RuntimeException("Dumping stsd to memory failed");
            }
            if (decSe instanceof AudioSampleEntry) {
                ((AudioSampleEntry)decSe).setType(frma.getDataFormat());
            } else if (decSe instanceof VisualSampleEntry) {
                ((VisualSampleEntry)decSe).setType(frma.getDataFormat());
            } else {
                throw new RuntimeException("I don't know " + decSe.getType());
            }
            LinkedList<Box> nuBoxes = new LinkedList<Box>();
            for (Box box : decSe.getBoxes()) {
                if (box.getType().equals("sinf")) continue;
                nuBoxes.add(box);
            }
            decSe.setBoxes(nuBoxes);
            this.cache.put(se, decSe);
        }
        return decSe;
    }
}

