/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.encryption;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import org.mp4parser.Container;
import org.mp4parser.boxes.iso23001.part7.TrackEncryptionBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.samplegrouping.GroupEntry;
import org.mp4parser.muxer.AbstractTrack;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.TrackMetaData;
import org.mp4parser.muxer.tracks.encryption.CencDecryptingSampleEntryTransformer;
import org.mp4parser.muxer.tracks.encryption.CencDecryptingSampleList;
import org.mp4parser.muxer.tracks.encryption.CencEncryptedTrack;
import org.mp4parser.tools.Path;
import org.mp4parser.tools.RangeStartMap;

public class CencDecryptingTrackImpl
extends AbstractTrack {
    private CencDecryptingSampleList samples;
    private CencEncryptedTrack original;
    private LinkedHashSet<SampleEntry> sampleEntries = new LinkedHashSet();

    public CencDecryptingTrackImpl(CencEncryptedTrack original, SecretKey sk) {
        super("dec(" + original.getName() + ")");
        this.original = original;
        HashMap<UUID, SecretKey> keys = new HashMap<UUID, SecretKey>();
        for (SampleEntry sampleEntry : original.getSampleEntries()) {
            TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath((Container)sampleEntry, (String)"sinf[0]/schi[0]/tenc[0]");
            assert (tenc != null);
            keys.put(tenc.getDefault_KID(), sk);
        }
        this.init(keys);
    }

    public CencDecryptingTrackImpl(CencEncryptedTrack original, Map<UUID, SecretKey> keys) {
        super("dec(" + original.getName() + ")");
        this.original = original;
        this.init(keys);
    }

    private void init(Map<UUID, SecretKey> keys) {
        CencDecryptingSampleEntryTransformer tx = new CencDecryptingSampleEntryTransformer();
        List<Sample> encSamples = this.original.getSamples();
        RangeStartMap indexToKey = new RangeStartMap();
        RangeStartMap indexToSampleEntry = new RangeStartMap();
        SampleEntry previousSampleEntry = null;
        for (int i = 0; i < encSamples.size(); ++i) {
            Sample encSample = encSamples.get(i);
            SampleEntry current = encSample.getSampleEntry();
            this.sampleEntries.add(tx.transform(encSample.getSampleEntry()));
            if (previousSampleEntry != current) {
                indexToSampleEntry.put((Comparable)Integer.valueOf(i), (Object)current);
                TrackEncryptionBox tenc = (TrackEncryptionBox)Path.getPath((Container)encSample.getSampleEntry(), (String)"sinf[0]/schi[0]/tenc[0]");
                if (tenc != null) {
                    indexToKey.put((Comparable)Integer.valueOf(i), (Object)keys.get(tenc.getDefault_KID()));
                } else {
                    indexToKey.put((Comparable)Integer.valueOf(i), null);
                }
            }
            previousSampleEntry = current;
        }
        this.samples = new CencDecryptingSampleList((RangeStartMap<Integer, SecretKey>)indexToKey, (RangeStartMap<Integer, SampleEntry>)indexToSampleEntry, encSamples, this.original.getSampleEncryptionEntries());
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    @Override
    public long[] getSyncSamples() {
        return this.original.getSyncSamples();
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return new ArrayList<SampleEntry>(this.sampleEntries);
    }

    @Override
    public long[] getSampleDurations() {
        return this.original.getSampleDurations();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.original.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.original.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public Map<GroupEntry, long[]> getSampleGroups() {
        return this.original.getSampleGroups();
    }
}

