/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.enums.Extended;
import com.uwetrottmann.trakt5.enums.IdType;
import com.uwetrottmann.trakt5.enums.Type;
import java.util.ArrayList;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mediaprovider.IMovieImdbMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktMovieMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktTVShowMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

@PluginImplementation
public class TraktMetadataProvider
implements IMovieMetadataProvider,
ITvShowMetadataProvider,
IMovieImdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktMetadataProvider.class);
    private static final String CLIENT_ID = ApiKey.decryptApikey((String)"Xd0t1yRY+HaxMl3bqILuxIaokXxekrFNj0QszCUsG6aNSbrhOhC2h5PcxDhV7wUXmBdOt9cYlMGNJjLZvKcS3xTRx3zYH7EYb7Mv5hCsMQU=");
    static final MediaProviderInfo providerInfo = TraktMetadataProvider.createMediaProviderInfo();
    private static TraktV2 api;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("trakt", "Trakt.tv", "<html><h3>Trakt.tv</h3><br />Trakt.tv is a platform that does many things, but primarily keeps track of TV shows and movies you watch. It also provides meta data for movies and TV shows<br /><br />Available languages: EN</html>", TraktMetadataProvider.class.getResource("/trakt_tv.png"));
        providerInfo.setVersion(TraktMetadataProvider.class);
        providerInfo.getConfig().addText("clientId", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    private static synchronized void initAPI() {
        String apiKey = CLIENT_ID;
        String userApiKey = providerInfo.getConfig().getValue("clientId");
        if (StringUtils.isNotBlank((CharSequence)userApiKey) && api != null && !userApiKey.equals(api.apiKey())) {
            api = null;
            apiKey = userApiKey;
        }
        if (StringUtils.isBlank((CharSequence)userApiKey) && api != null && !CLIENT_ID.equals(api.apiKey())) {
            api = null;
            apiKey = CLIENT_ID;
        }
        if (api == null) {
            api = new TraktV2(apiKey){

                protected synchronized OkHttpClient okHttpClient() {
                    OkHttpClient.Builder builder = TmmHttpClient.newBuilder((boolean)true);
                    builder.addInterceptor((Interceptor)new TraktV2Interceptor((TraktV2)this));
                    return builder.build();
                }
            };
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaSearchResult> lookupWithId(MediaSearchOptions options) {
        String imdbId;
        List<SearchResult> results = new ArrayList<SearchResult>();
        String string = imdbId = options.getImdbId().isEmpty() ? null : options.getImdbId();
        if (MetadataUtil.isValidImdbId((String)options.getQuery())) {
            imdbId = options.getQuery();
        }
        String traktId = options.getIdAsString(providerInfo.getId());
        String tmdbId = options.getIdAsString("tmdb");
        String tvdbId = options.getIdAsString("tvdb");
        String tvrageId = options.getIdAsString("tvrage");
        Type type = null;
        switch (options.getMediaType()) {
            case MOVIE: {
                type = Type.MOVIE;
                break;
            }
            case TV_SHOW: {
                type = Type.SHOW;
                break;
            }
            case TV_EPISODE: {
                type = Type.EPISODE;
                break;
            }
        }
        results = this.lookupWithId(results, IdType.TRAKT, traktId, type);
        results = this.lookupWithId(results, IdType.IMDB, imdbId, type);
        results = this.lookupWithId(results, IdType.TMDB, tmdbId, type);
        results = this.lookupWithId(results, IdType.TVDB, tvdbId, type);
        results = this.lookupWithId(results, IdType.TVRAGE, tvrageId, type);
        ArrayList<MediaSearchResult> msr = new ArrayList<MediaSearchResult>();
        for (SearchResult sr : results) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, sr);
            m.setScore(1.0f);
            msr.add(m);
        }
        return msr;
    }

    private List<SearchResult> lookupWithId(List<SearchResult> results, IdType id, String value, Type type) {
        TraktMetadataProvider.initAPI();
        if (results.isEmpty() && value != null) {
            LOGGER.debug("found {} id {} - direct lookup", (Object)id, (Object)value);
            try {
                Response response = api.search().idLookup(id, value, type, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    return results;
                }
                results = (List)response.body();
                LOGGER.debug("Found {} result with ID lookup", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.warn("request was NOT successful: {}", (Object)e.getMessage());
            }
        }
        return results;
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        LOGGER.debug("search() - {}", (Object)options.toString());
        TraktMetadataProvider.initAPI();
        List<MediaSearchResult> results = this.lookupWithId(options);
        if (!results.isEmpty()) {
            return results;
        }
        switch (options.getMediaType()) {
            case MOVIE: {
                return new TraktMovieMetadataProvider(api).search(options);
            }
            case TV_SHOW: {
                return new TraktTVShowMetadataProvider(api).search(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getMediaType());
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws ScrapeException, UnsupportedMediaTypeException, MissingIdException, NothingFoundException {
        TraktMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: {
                return new TraktMovieMetadataProvider(api).scrape(options);
            }
            case TV_SHOW: 
            case TV_EPISODE: {
                return new TraktTVShowMetadataProvider(api).scrape(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    public List<MediaMetadata> getEpisodeList(MediaScrapeOptions mediaScrapeOptions) throws ScrapeException, UnsupportedMediaTypeException, MissingIdException {
        TraktMetadataProvider.initAPI();
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return new TraktTVShowMetadataProvider(api).getEpisodeList(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }
}

