/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.trakt;

import com.uwetrottmann.trakt5.TraktV2;
import com.uwetrottmann.trakt5.entities.CastMember;
import com.uwetrottmann.trakt5.entities.Credits;
import com.uwetrottmann.trakt5.entities.CrewMember;
import com.uwetrottmann.trakt5.entities.Episode;
import com.uwetrottmann.trakt5.entities.SearchResult;
import com.uwetrottmann.trakt5.entities.Season;
import com.uwetrottmann.trakt5.entities.Show;
import com.uwetrottmann.trakt5.entities.Translation;
import com.uwetrottmann.trakt5.enums.Extended;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.trakt.TraktMetadataProvider;
import org.tinymediamanager.scraper.trakt.TraktUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

class TraktTVShowMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraktTVShowMetadataProvider.class);
    private final TraktV2 api;

    TraktTVShowMetadataProvider(TraktV2 api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        String year = null;
        if (options.getYear() > 1800) {
            year = String.valueOf(options.getYear());
        }
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        List searchResults = null;
        String lang = options.getLanguage().getLanguage();
        lang = lang + ",en";
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.search().textQueryShow(searchString, year, null, lang, null, null, null, null, null, null, Extended.FULL, Integer.valueOf(1), Integer.valueOf(25)).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                searchResults = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to search: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        if (searchResults == null || searchResults.isEmpty()) {
            LOGGER.info("nothing found");
            return results;
        }
        for (SearchResult result : searchResults) {
            MediaSearchResult m = TraktUtils.morphTraktResultToTmmResult(options, result);
            m.setScore(MetadataUtil.calculateScore((String)searchString, (String)m.getTitle()));
            results.add(m);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        LOGGER.debug("getEpisodeList() " + options.toString());
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"imdb", TraktMetadataProvider.providerInfo.getId()});
        }
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.seasons().summary(id, Extended.FULLEPISODES).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                seasons = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get episode list: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
            for (Episode episode : season.episodes) {
                MediaMetadata ep = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
                ep.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number}));
                ep.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.season}));
                ep.setTitle(episode.title);
                if (episode.rating != null) {
                    MediaRating rating = new MediaRating(TraktMetadataProvider.providerInfo.getId());
                    rating.setRating((double)Math.round(episode.rating * 10.0) / 10.0);
                    rating.setVoteCount(episode.votes.intValue());
                    rating.setMaxValue(10);
                    ep.addRating(rating);
                }
                if (episode.first_aired != null) {
                    ep.setReleaseDate(TraktUtils.toDate(episode.first_aired));
                }
                if (episode.ids != null) {
                    ep.setId(TraktMetadataProvider.providerInfo.getId(), (Object)episode.ids.trakt);
                    if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
                        ep.setId("tvdb", (Object)episode.ids.tvdb);
                    }
                    if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
                        ep.setId("tmdb", (Object)episode.ids.tmdb);
                    }
                    if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
                        ep.setId("tvrage", (Object)episode.ids.tvrage);
                    }
                    if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
                        ep.setId("imdb", (Object)episode.ids.imdb);
                    }
                }
                episodes.add(ep);
            }
        }
        return episodes;
    }

    MediaMetadata scrape(MediaScrapeOptions options) throws ScrapeException, UnsupportedMediaTypeException, MissingIdException, NothingFoundException {
        switch (options.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(options);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        Translation trans;
        LOGGER.debug("getTvShowMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"imdb", TraktMetadataProvider.providerInfo.getId()});
        }
        String lang = options.getLanguage().getLanguage();
        List translations = null;
        Show show = null;
        Credits credits = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.shows().summary(id, Extended.FULL).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                show = (Show)response.body();
                if (!"en".equals(lang)) {
                    translations = (List)this.api.shows().translation(id, lang).execute().body();
                }
                credits = (Credits)this.api.shows().people(id).execute().body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        if (show == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)show.ids.trakt);
        if (show.ids.tvdb != null && show.ids.tvdb > 0) {
            md.setId("tvdb", (Object)show.ids.tvdb);
        }
        if (show.ids.tmdb != null && show.ids.tmdb > 0) {
            md.setId("tmdb", (Object)show.ids.tmdb);
        }
        if (show.ids.tvrage != null && show.ids.tvrage > 0) {
            md.setId("tvrage", (Object)show.ids.tvrage);
        }
        if (StringUtils.isNotBlank((CharSequence)show.ids.imdb)) {
            md.setId("imdb", (Object)show.ids.imdb);
        }
        Translation translation = trans = translations == null || translations.isEmpty() ? null : (Translation)translations.get(0);
        if (trans != null) {
            md.setTitle(trans.title.isEmpty() ? show.title : trans.title);
            md.setPlot(trans.overview.isEmpty() ? show.overview : trans.overview);
        } else {
            md.setTitle(show.title);
            md.setPlot(show.overview);
        }
        md.setYear(show.year);
        MediaRating rating = new MediaRating("trakt");
        rating.setRating(show.rating.doubleValue());
        rating.setVoteCount(show.votes.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        md.addCertification(Certification.findCertification((String)show.certification));
        md.addCountry(show.country);
        md.setReleaseDate(TraktUtils.toDate(show.first_aired));
        if (show.status != null) {
            md.setStatus(show.status.toString());
        }
        md.setRuntime(show.runtime);
        md.addProductionCompany(show.network);
        for (String genreAsString : ListUtils.nullSafe((Iterable)show.genres)) {
            md.addGenre(MediaGenres.getGenre((String)genreAsString));
        }
        if (credits != null) {
            for (CastMember cast : ListUtils.nullSafe((Iterable)credits.cast)) {
                md.addCastMember(TraktUtils.toTmmCast(cast, MediaCastMember.CastType.ACTOR));
            }
            if (credits.crew != null) {
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.directing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.DIRECTOR));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.production)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.PRODUCER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.writing)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.WRITER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.costumeAndMakeUp)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.sound)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.camera)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
                for (CrewMember crew : ListUtils.nullSafe((Iterable)credits.crew.art)) {
                    md.addCastMember(TraktUtils.toTmmCast(crew, MediaCastMember.CastType.OTHER));
                }
            }
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        LOGGER.debug("getEpisodeMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TraktMetadataProvider.providerInfo.getId());
        String id = options.getIdAsString(TraktMetadataProvider.providerInfo.getId());
        if (StringUtils.isBlank((CharSequence)id)) {
            id = options.getIdAsString("imdb");
        }
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{"imdb", TraktMetadataProvider.providerInfo.getId()});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        String aired = "";
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            aired = formatter.format((Object)options.getMetadata().getReleaseDate());
        }
        if (aired.isEmpty() && (seasonNr == -1 || episodeNr == -1)) {
            throw new MissingIdException(new String[]{"seasonNr", "episodeNr"});
        }
        Episode episode = null;
        List seasons = null;
        TraktV2 traktV2 = this.api;
        synchronized (traktV2) {
            try {
                Response response = this.api.seasons().summary(id, Extended.FULLEPISODES).execute();
                if (!response.isSuccessful()) {
                    LOGGER.warn("request was NOT successful: HTTP/{} - {}", (Object)response.code(), (Object)response.message());
                    throw new HttpException(response.code(), response.message());
                }
                seasons = (List)response.body();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get meta data: " + e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
        block5: for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
            for (Episode ep : season.episodes) {
                if (ep.season != seasonNr || ep.number != episodeNr) continue;
                episode = ep;
                continue block5;
            }
        }
        if (episode == null && !aired.isEmpty()) {
            block7: for (Season season : ListUtils.nullSafe((Iterable)seasons)) {
                for (Episode ep : season.episodes) {
                    SimpleDateFormat formatter;
                    String epAired;
                    if (ep.first_aired == null || !(epAired = (formatter = new SimpleDateFormat("yyyy-MM-dd")).format((Object)TraktUtils.toDate(ep.first_aired))).equals(aired)) continue;
                    episode = ep;
                    continue block7;
                }
            }
        }
        if (episode == null) {
            LOGGER.warn("nothing found");
            throw new NothingFoundException();
        }
        md.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number}));
        md.setAbsoluteNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{episode.number_abs}));
        md.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{episode.season}));
        md.setId(TraktMetadataProvider.providerInfo.getId(), (Object)episode.ids.trakt);
        if (episode.ids.tvdb != null && episode.ids.tvdb > 0) {
            md.setId("tvdb", (Object)episode.ids.tvdb);
        }
        if (episode.ids.tmdb != null && episode.ids.tmdb > 0) {
            md.setId("tmdb", (Object)episode.ids.tmdb);
        }
        if (StringUtils.isNotBlank((CharSequence)episode.ids.imdb)) {
            md.setId("imdb", (Object)episode.ids.imdb);
        }
        if (episode.ids.tvrage != null && episode.ids.tvrage > 0) {
            md.setId("tvrage", (Object)episode.ids.tvrage);
        }
        md.setTitle(episode.title);
        md.setPlot(episode.overview);
        MediaRating rating = new MediaRating("trakt");
        rating.setRating(episode.rating.doubleValue());
        rating.setVoteCount(episode.votes.intValue());
        rating.setMaxValue(10);
        md.addRating(rating);
        md.setReleaseDate(TraktUtils.toDate(episode.first_aired));
        return md;
    }
}

