/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.thetvdb;

import com.uwetrottmann.thetvdb.TheTvdb;
import com.uwetrottmann.thetvdb.entities.LoginData;
import com.uwetrottmann.thetvdb.entities.Token;
import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import retrofit2.Call;

public class TheTvdbAuthenticator
implements Authenticator {
    public static final String PATH_LOGIN = "/login";
    private TheTvdb theTvdb;

    public TheTvdbAuthenticator(TheTvdb theTvdb) {
        this.theTvdb = theTvdb;
    }

    @Nullable
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        return TheTvdbAuthenticator.handleRequest(response, this.theTvdb);
    }

    @Nullable
    public static Request handleRequest(Response response, TheTvdb theTvdb) throws IOException {
        String path = response.request().url().encodedPath();
        if (PATH_LOGIN.equals(path)) {
            return null;
        }
        if (TheTvdbAuthenticator.responseCount(response) >= 2) {
            return null;
        }
        Call<Token> loginCall = theTvdb.authentication().login(new LoginData(theTvdb.apiKey()));
        retrofit2.Response loginResponse = loginCall.execute();
        Token body = (Token)loginResponse.body();
        if (!loginResponse.isSuccessful() || body == null) {
            return null;
        }
        String jsonWebToken = body.token;
        theTvdb.jsonWebToken(jsonWebToken);
        return response.request().newBuilder().header("Authorization", "Bearer " + jsonWebToken).build();
    }

    private static int responseCount(Response response) {
        int result = 1;
        while ((response = response.priorResponse()) != null) {
            ++result;
        }
        return result;
    }
}

