/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.thetvdb;

import com.uwetrottmann.thetvdb.TheTvdb;
import com.uwetrottmann.thetvdb.entities.Actor;
import com.uwetrottmann.thetvdb.entities.ActorsResponse;
import com.uwetrottmann.thetvdb.entities.Episode;
import com.uwetrottmann.thetvdb.entities.EpisodeResponse;
import com.uwetrottmann.thetvdb.entities.EpisodesResponse;
import com.uwetrottmann.thetvdb.entities.Language;
import com.uwetrottmann.thetvdb.entities.LanguagesResponse;
import com.uwetrottmann.thetvdb.entities.Series;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResult;
import com.uwetrottmann.thetvdb.entities.SeriesImageQueryResultResponse;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParam;
import com.uwetrottmann.thetvdb.entities.SeriesImagesQueryParamResponse;
import com.uwetrottmann.thetvdb.entities.SeriesResponse;
import com.uwetrottmann.thetvdb.entities.SeriesResultsResponse;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.util.TvUtils;
import retrofit2.Response;

@PluginImplementation
public class TheTvDbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TheTvDbMetadataProvider.class);
    private static String artworkUrl = "http://thetvdb.com/banners/";
    private static final String TMM_API_KEY = ApiKey.decryptApikey((String)"7bHHg4k0XhRERM8xd3l+ElhMUXOA5Ou4vQUEzYLGHt8=");
    private static final String FALLBACK_LANGUAGE = "fallbackLanguage";
    private final CacheMap<Integer, List<MediaMetadata>> episodeListCacheMap;
    private final MediaProviderInfo providerInfo = this.createMediaProviderInfo();
    private TheTvdb tvdb;
    private List<Language> tvdbLanguages;

    public TheTvDbMetadataProvider() {
        this.episodeListCacheMap = new CacheMap(600L, 5L);
    }

    private synchronized void initAPI() throws ScrapeException {
        String apiKey = TMM_API_KEY;
        String userApiKey = this.providerInfo.getConfig().getValue("apiKey");
        if (StringUtils.isNotBlank((CharSequence)userApiKey) && this.tvdb != null && !userApiKey.equals(this.tvdb.apiKey())) {
            this.tvdb = null;
            apiKey = userApiKey;
        }
        if (StringUtils.isBlank((CharSequence)userApiKey) && this.tvdb != null && !TMM_API_KEY.equals(this.tvdb.apiKey())) {
            this.tvdb = null;
            apiKey = TMM_API_KEY;
        }
        if (this.tvdb == null) {
            try {
                this.tvdb = new TheTvdb(apiKey){
                    private OkHttpClient okHttpClient;

                    @Override
                    protected synchronized OkHttpClient okHttpClient() {
                        if (this.okHttpClient == null) {
                            OkHttpClient.Builder builder = TmmHttpClient.newBuilder((boolean)true);
                            this.setOkHttpClientDefaults(builder);
                            this.okHttpClient = builder.build();
                        }
                        return this.okHttpClient;
                    }
                };
                Response httpResponse = this.tvdb.languages().allAvailable().execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                LanguagesResponse response = (LanguagesResponse)httpResponse.body();
                if (response == null) {
                    throw new Exception("Could not connect to TVDB");
                }
                this.tvdbLanguages = response.data;
            }
            catch (Exception e) {
                LOGGER.warn("could not initialize API: {}", (Object)e.getMessage());
                throw new ScrapeException((Throwable)e);
            }
        }
    }

    private MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("tvdb", "thetvdb.com", "<html><h3>The TV DB</h3><br />An open database for television fans. This scraper is able to scrape TV series metadata and artwork</html>", TheTvDbMetadataProvider.class.getResource("/thetvdb_com.png"));
        providerInfo.setVersion(TheTvDbMetadataProvider.class);
        providerInfo.getConfig().addText("apiKey", "", true);
        ArrayList<String> fallbackLanguages = new ArrayList<String>();
        for (MediaLanguages mediaLanguages : MediaLanguages.values()) {
            fallbackLanguages.add(mediaLanguages.toString());
        }
        providerInfo.getConfig().addSelect(FALLBACK_LANGUAGE, fallbackLanguages.toArray(new String[0]), MediaLanguages.en.toString());
        providerInfo.getConfig().load();
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions mediaScrapeOptions) throws ScrapeException, MissingIdException, UnsupportedMediaTypeException, NothingFoundException {
        this.initAPI();
        LOGGER.debug("getting metadata: {}", (Object)mediaScrapeOptions);
        switch (mediaScrapeOptions.getType()) {
            case TV_SHOW: {
                return this.getTvShowMetadata(mediaScrapeOptions);
            }
            case TV_EPISODE: {
                return this.getEpisodeMetadata(mediaScrapeOptions);
            }
        }
        throw new UnsupportedMediaTypeException(mediaScrapeOptions.getType());
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws ScrapeException, UnsupportedMediaTypeException {
        Object res;
        Response httpResponse;
        String imdbId;
        this.initAPI();
        LOGGER.debug("search() {}", (Object)options);
        ArrayList<MediaSearchResult> results = new ArrayList<MediaSearchResult>();
        if (options.getMediaType() != MediaType.TV_SHOW) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            searchString = options.getQuery();
        }
        String string = imdbId = options.getImdbId().isEmpty() ? null : options.getImdbId();
        if (MetadataUtil.isValidImdbId((String)searchString)) {
            imdbId = searchString;
            searchString = null;
        }
        if (!StringUtils.isEmpty((CharSequence)imdbId)) {
            searchString = null;
        }
        int tvdbId = options.getIdAsInt(this.providerInfo.getId());
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get((String)this.providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
        ArrayList<Object> series = new ArrayList<Object>();
        if (tvdbId != 0) {
            LOGGER.debug("found TvDb ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.tvdb.series().series(tvdbId, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                res = ((SeriesResponse)httpResponse.body()).data;
                this.fillFallbackLanguages(language, fallbackLanguage, (Series)res);
                series.add(res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb via ID: {}", (Object)e.getMessage());
            }
        }
        if (!(!series.isEmpty() || StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isEmpty((CharSequence)imdbId))) {
            try {
                httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, language).execute();
                if (!httpResponse.isSuccessful()) {
                    if (!fallbackLanguage.equals(language)) {
                        LOGGER.debug("not found - trying with fallback language {}", (Object)fallbackLanguage);
                        httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, fallbackLanguage).execute();
                    }
                    if (!httpResponse.isSuccessful()) {
                        if (!fallbackLanguage.equals("en") && !language.equals("en")) {
                            LOGGER.debug("not found - trying with EN language");
                            httpResponse = this.tvdb.search().series(searchString, imdbId, null, null, "en").execute();
                        }
                        if (!httpResponse.isSuccessful()) {
                            throw new HttpException(httpResponse.code(), httpResponse.message());
                        }
                    }
                }
                res = ((SeriesResultsResponse)httpResponse.body()).data;
                Iterator iterator = res.iterator();
                while (iterator.hasNext()) {
                    Series s = (Series)iterator.next();
                    this.fillFallbackLanguages(language, fallbackLanguage, s);
                }
                series.addAll((Collection<Object>)res);
            }
            catch (Exception e) {
                LOGGER.error("problem getting data vom tvdb: {}", (Object)e.getMessage());
            }
        }
        if (series.isEmpty()) {
            return results;
        }
        HashMap<Integer, MediaSearchResult> resultMap = new HashMap<Integer, MediaSearchResult>();
        for (Series series2 : series) {
            if (resultMap.containsKey(series2.id)) continue;
            MediaSearchResult result = new MediaSearchResult(this.providerInfo.getId(), options.getMediaType());
            result.setId(series2.id.toString());
            result.setTitle(series2.seriesName);
            result.setOverview(series2.overview);
            try {
                result.setYear(Integer.parseInt(series2.firstAired.substring(0, 4)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                SeriesImageQueryResultResponse response;
                Response httpResponse2 = this.tvdb.series().imagesQuery(series2.id, "poster", null, null, null).execute();
                if (httpResponse2.isSuccessful() && (response = (SeriesImageQueryResultResponse)httpResponse2.body()) != null && !response.data.isEmpty()) {
                    result.setPosterUrl(artworkUrl + response.data.get((int)0).fileName);
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not get poster for search result: {}", (Object)e.getMessage());
            }
            float score = MetadataUtil.calculateScore((String)searchString, (String)series2.seriesName);
            if (this.yearDiffers(options.getYear(), result.getYear())) {
                float diff = (float)Math.abs(options.getYear() - result.getYear()) / 100.0f;
                LOGGER.debug("parsed year does not match search result year - downgrading score by {}", (Object)Float.valueOf(diff));
                score -= diff;
            }
            result.setScore(score);
            resultMap.put(series2.id, result);
        }
        results.addAll(resultMap.values());
        Collections.sort(results);
        Collections.reverse(results);
        return results;
    }

    private void fillFallbackLanguages(String language, String fallbackLanguage, Series serie) throws IOException {
        Response httpResponse;
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals(language)) {
            LOGGER.trace("Getting show in fallback language {}", (Object)fallbackLanguage);
            httpResponse = this.tvdb.series().series(serie.id, fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            String string = serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
        if ((StringUtils.isEmpty((CharSequence)serie.seriesName) || StringUtils.isEmpty((CharSequence)serie.overview)) && !fallbackLanguage.equals("en") && !language.equals("en")) {
            LOGGER.trace("Getting show in fallback language {}", (Object)"en");
            httpResponse = this.tvdb.series().series(serie.id, "en").execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            serie.seriesName = StringUtils.isEmpty((CharSequence)serie.seriesName) ? ((SeriesResponse)httpResponse.body()).data.seriesName : serie.seriesName;
            serie.overview = StringUtils.isEmpty((CharSequence)serie.overview) ? ((SeriesResponse)httpResponse.body()).data.overview : serie.overview;
        }
    }

    private void fillFallbackLanguages(String language, String fallbackLanguage, Episode episode) throws IOException {
        Response httpResponse;
        if ((StringUtils.isEmpty((CharSequence)episode.episodeName) || StringUtils.isEmpty((CharSequence)episode.overview)) && !fallbackLanguage.equals(language)) {
            LOGGER.trace("Getting episode S{}E{} in fallback language {}", new Object[]{episode.airedSeason, episode.airedEpisodeNumber, fallbackLanguage});
            httpResponse = this.tvdb.episodes().get(episode.id, fallbackLanguage).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode.episodeName = StringUtils.isEmpty((CharSequence)episode.episodeName) ? ((EpisodeResponse)httpResponse.body()).data.episodeName : episode.episodeName;
            String string = episode.overview = StringUtils.isEmpty((CharSequence)episode.overview) ? ((EpisodeResponse)httpResponse.body()).data.overview : episode.overview;
        }
        if ((StringUtils.isEmpty((CharSequence)episode.episodeName) || StringUtils.isEmpty((CharSequence)episode.overview)) && !fallbackLanguage.equals("en") && !language.equals("en")) {
            LOGGER.trace("Getting episode S{}E{} in fallback language {}", new Object[]{episode.airedSeason, episode.airedEpisodeNumber, "en"});
            httpResponse = this.tvdb.episodes().get(episode.id, "en").execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            episode.episodeName = StringUtils.isEmpty((CharSequence)episode.episodeName) ? ((EpisodeResponse)httpResponse.body()).data.episodeName : episode.episodeName;
            episode.overview = StringUtils.isEmpty((CharSequence)episode.overview) ? ((EpisodeResponse)httpResponse.body()).data.overview : episode.overview;
        }
    }

    private MediaMetadata getTvShowMetadata(MediaScrapeOptions options) throws ScrapeException, MissingIdException, NothingFoundException {
        MediaMetadata md = new MediaMetadata(this.providerInfo.getId());
        Integer id = options.getIdAsInteger(this.providerInfo.getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        String language = options.getLanguage().getLanguage();
        String fallbackLanguage = MediaLanguages.get((String)this.providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
        Series show = null;
        try {
            Response httpResponse = this.tvdb.series().series(id, options.getLanguage().getLanguage()).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            show = ((SeriesResponse)httpResponse.body()).data;
            this.fillFallbackLanguages(language, fallbackLanguage, show);
        }
        catch (Exception e) {
            LOGGER.error("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        md.setId(this.providerInfo.getId(), (Object)show.id);
        md.setTitle(show.seriesName);
        if (StringUtils.isNotBlank((CharSequence)show.imdbId)) {
            md.setId("imdb", (Object)show.imdbId);
        }
        if (StringUtils.isNotBlank((CharSequence)show.zap2itId)) {
            md.setId("zap2it", (Object)show.zap2itId);
        }
        md.setPlot(show.overview);
        try {
            md.setRuntime(Integer.valueOf(show.runtime));
        }
        catch (NumberFormatException e) {
            md.setRuntime(0);
        }
        MediaRating rating = new MediaRating(this.getProviderInfo().getId());
        rating.setRating(show.siteRating.doubleValue());
        rating.setVoteCount(TvUtils.parseInt((Object[])new Object[]{show.siteRatingCount}));
        rating.setMaxValue(10);
        md.addRating(rating);
        try {
            md.setReleaseDate(StrgUtils.parseDate((String)show.firstAired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            Date date = StrgUtils.parseDate((String)show.firstAired);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int y = calendar.get(1);
            md.setYear(y);
            if (y != 0 && md.getTitle().contains(String.valueOf(y))) {
                LOGGER.debug("Weird TVDB entry - removing date {} from title", (Object)y);
                String t = show.seriesName.replaceAll(String.valueOf(y), "").replaceAll("\\(\\)", "").trim();
                md.setTitle(t);
            }
        }
        catch (Exception date) {
            // empty catch block
        }
        md.setStatus(show.status);
        md.addProductionCompany(show.network);
        ArrayList<Actor> actors = new ArrayList<Actor>();
        try {
            Response httpResponse = this.tvdb.series().actors(id).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            actors.addAll(((ActorsResponse)httpResponse.body()).data);
        }
        catch (Exception e) {
            LOGGER.error("failed to get actors: {}", (Object)e.getMessage());
        }
        for (Actor actor : actors) {
            MediaCastMember member = new MediaCastMember(MediaCastMember.CastType.ACTOR);
            member.setId(this.providerInfo.getId(), (Object)actor.id);
            member.setName(actor.name);
            member.setCharacter(actor.role);
            if (StringUtils.isNotBlank((CharSequence)actor.image)) {
                member.setImageUrl(artworkUrl + actor.image);
            }
            md.addCastMember(member);
        }
        md.addCertification(Certification.findCertification((String)show.rating));
        for (String genreAsString : show.genre) {
            md.addGenre(MediaGenres.getGenre((String)genreAsString));
        }
        return md;
    }

    private MediaMetadata getEpisodeMetadata(MediaScrapeOptions options) throws ScrapeException, NothingFoundException, MissingIdException {
        boolean useDvdOrder = false;
        Integer showId = options.getIdAsInteger(this.providerInfo.getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if (seasonNr == -1 || episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("dvdSeasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("dvdEpisodeNr", -1);
            useDvdOrder = true;
        }
        Date releaseDate = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            releaseDate = options.getMetadata().getReleaseDate();
        }
        if (releaseDate == null && (seasonNr == -1 || episodeNr == -1)) {
            LOGGER.warn("no aired date/season number/episode number found");
            throw new MissingIdException(new String[]{"episodeNr", "seasonNr"});
        }
        List<MediaMetadata> episodes = (List<MediaMetadata>)this.episodeListCacheMap.get((Object)showId);
        if (episodes == null) {
            episodes = this.getEpisodeList(options);
        }
        MediaMetadata foundEpisode = null;
        for (MediaMetadata episode : episodes) {
            if (useDvdOrder && episode.getDvdSeasonNumber() == seasonNr && episode.getDvdEpisodeNumber() == episodeNr) {
                foundEpisode = episode;
                break;
            }
            if (useDvdOrder || episode.getSeasonNumber() != seasonNr || episode.getEpisodeNumber() != episodeNr) continue;
            foundEpisode = episode;
            break;
        }
        if (foundEpisode == null && releaseDate != null) {
            for (MediaMetadata episode : episodes) {
                if (episode.getReleaseDate() != releaseDate) continue;
                foundEpisode = episode;
                break;
            }
        }
        if (foundEpisode == null) {
            throw new NothingFoundException();
        }
        return foundEpisode;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        this.initAPI();
        LOGGER.debug("getting artwork: {}", (Object)options);
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        Integer id = options.getIdAsInteger(this.providerInfo.getId());
        if (id == null || id == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        ArrayList<SeriesImageQueryResult> images = new ArrayList<SeriesImageQueryResult>();
        try {
            SeriesImagesQueryParamResponse response = (SeriesImagesQueryParamResponse)this.tvdb.series().imagesQueryParams(id).execute().body();
            for (SeriesImagesQueryParam param : response.data) {
                if (!(options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || "fanart".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.BACKGROUND || "poster".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.POSTER || "season".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_POSTER || "seasonwide".equals(param.keyType) && options.getArtworkType() == MediaArtwork.MediaArtworkType.SEASON_BANNER) && (!"series".equals(param.keyType) || options.getArtworkType() != MediaArtwork.MediaArtworkType.BANNER)) continue;
                try {
                    Response httpResponse = this.tvdb.series().imagesQuery(id, param.keyType, null, null, null).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    images.addAll(((SeriesImageQueryResultResponse)httpResponse.body()).data);
                }
                catch (Exception e) {
                    LOGGER.error("could not get artwork from tvdb: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get artwork: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        if (images.isEmpty()) {
            return artwork;
        }
        images.sort(new ImageComparator(options.getLanguage().getLanguage()));
        block29: for (SeriesImageQueryResult image : images) {
            MediaArtwork ma = null;
            switch (image.keyType) {
                case "fanart": {
                    ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                    break;
                }
                case "poster": {
                    ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                    break;
                }
                case "season": {
                    ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.SEASON_POSTER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "seasonwide": {
                    ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.SEASON_BANNER);
                    try {
                        ma.setSeason(Integer.parseInt(image.subKey));
                    }
                    catch (Exception e) {
                        LOGGER.warn("could not parse season: {}", (Object)image.subKey);
                    }
                    break;
                }
                case "series": {
                    ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.BANNER);
                    break;
                }
                default: {
                    continue block29;
                }
            }
            if (StringUtils.isNotBlank((CharSequence)image.resolution)) {
                try {
                    Pattern pattern = Pattern.compile("([0-9]{3,4})x([0-9]{3,4})");
                    Matcher matcher = pattern.matcher(image.resolution);
                    if (matcher.matches() && matcher.groupCount() > 1) {
                        int width = Integer.parseInt(matcher.group(1));
                        int height = Integer.parseInt(matcher.group(2));
                        ma.addImageSize(width, height, artworkUrl + image.fileName);
                        switch (ma.getType()) {
                            case POSTER: {
                                if (width >= 1000) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 500) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.BIG.getOrder());
                                    break;
                                }
                                if (width >= 342) {
                                    ma.setSizeOrder(MediaArtwork.PosterSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.PosterSizes.SMALL.getOrder());
                                break;
                            }
                            case BACKGROUND: {
                                if (width >= 3840) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.XLARGE.getOrder());
                                }
                                if (width >= 1920) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
                                    break;
                                }
                                if (width >= 1280) {
                                    ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
                                    break;
                                }
                                ma.setSizeOrder(MediaArtwork.FanartSizes.SMALL.getOrder());
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("could not extract size from artwork: {}", (Object)image.resolution);
                }
            }
            if (ma.getType() == MediaArtwork.MediaArtworkType.SEASON_BANNER || ma.getType() == MediaArtwork.MediaArtworkType.SEASON_POSTER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
            } else if (ma.getType() == MediaArtwork.MediaArtworkType.BANNER) {
                ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
            }
            ma.setDefaultUrl(artworkUrl + image.fileName);
            if (StringUtils.isNotBlank((CharSequence)image.thumbnail)) {
                ma.setPreviewUrl(artworkUrl + image.thumbnail);
            } else {
                ma.setPreviewUrl(ma.getDefaultUrl());
            }
            artwork.add(ma);
        }
        return artwork;
    }

    public List<MediaMetadata> getEpisodeList(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        this.initAPI();
        LOGGER.debug("getting episode list: {}", (Object)options);
        ArrayList<MediaMetadata> episodes = new ArrayList<MediaMetadata>();
        Integer showId = options.getIdAsInteger(this.providerInfo.getId());
        if (showId == null || showId == 0) {
            LOGGER.warn("no id available");
            throw new MissingIdException(new String[]{this.providerInfo.getId()});
        }
        ArrayList<Episode> eps = new ArrayList<Episode>();
        try {
            String language = options.getLanguage().getLanguage();
            String fallbackLanguage = MediaLanguages.get((String)this.providerInfo.getConfig().getValue(FALLBACK_LANGUAGE)).getLanguage();
            int counter = 1;
            while (true) {
                Response httpResponse;
                if (!(httpResponse = this.tvdb.series().episodes(showId, counter, language).execute()).isSuccessful() && counter == 1) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                if (httpResponse.isSuccessful() || counter <= 1) {
                    Iterator<String> response = (EpisodesResponse)httpResponse.body();
                    for (Episode ep : ((EpisodesResponse)((Object)response)).data) {
                        this.fillFallbackLanguages(language, fallbackLanguage, ep);
                    }
                    eps.addAll(((EpisodesResponse)((Object)response)).data);
                    if (((EpisodesResponse)((Object)response)).data.size() >= 100) {
                        ++counter;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException((Throwable)e);
        }
        for (Episode ep : eps) {
            MediaCastMember cm;
            String[] multiple;
            MediaMetadata episode = new MediaMetadata(this.providerInfo.getId());
            episode.setId(this.providerInfo.getId(), (Object)ep.id);
            episode.setSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{ep.airedSeason}));
            episode.setEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{ep.airedEpisodeNumber}));
            episode.setDvdSeasonNumber(TvUtils.getSeasonNumber((Object[])new Object[]{ep.dvdSeason}));
            episode.setDvdEpisodeNumber(TvUtils.getEpisodeNumber((Object[])new Object[]{ep.dvdEpisodeNumber}));
            episode.setTitle(ep.episodeName);
            episode.setPlot(ep.overview);
            try {
                episode.setReleaseDate(StrgUtils.parseDate((String)ep.firstAired));
            }
            catch (Exception ignored) {
                LOGGER.warn("Could not parse date: {}", (Object)ep.firstAired);
            }
            MediaRating rating = new MediaRating(this.getProviderInfo().getId());
            rating.setRating(ep.siteRating.doubleValue());
            rating.setVoteCount(TvUtils.parseInt((Object[])new Object[]{ep.siteRatingCount}));
            rating.setMaxValue(10);
            episode.addRating(rating);
            if (ep.directors != null && !ep.directors.isEmpty()) {
                for (String director : ep.directors) {
                    for (String g2 : multiple = director.split(",")) {
                        cm = new MediaCastMember(MediaCastMember.CastType.DIRECTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.writers != null && !ep.writers.isEmpty()) {
                for (String writer : ep.writers) {
                    for (String g2 : multiple = writer.split(",")) {
                        cm = new MediaCastMember(MediaCastMember.CastType.WRITER);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (ep.guestStars != null && !ep.guestStars.isEmpty()) {
                for (String guest : ep.guestStars) {
                    for (String g2 : multiple = guest.split(",")) {
                        cm = new MediaCastMember(MediaCastMember.CastType.ACTOR);
                        cm.setName(g2.trim());
                        episode.addCastMember(cm);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)ep.filename) && (options.getArtworkType() == MediaArtwork.MediaArtworkType.ALL || options.getArtworkType() == MediaArtwork.MediaArtworkType.THUMB)) {
                MediaArtwork ma = new MediaArtwork(this.providerInfo.getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(artworkUrl + ep.filename);
                ma.setDefaultUrl(artworkUrl + ep.filename);
                episode.addMediaArt(ma);
            }
            episodes.add(episode);
        }
        this.episodeListCacheMap.put((Object)showId, episodes);
        return episodes;
    }

    private boolean yearDiffers(int i1, int i2) {
        return i1 != 0 && i2 != 0 && i1 != i2;
    }

    @Deprecated
    private String cleanString(String oldString) {
        if (StringUtils.isEmpty((CharSequence)oldString)) {
            return "";
        }
        String newString = oldString.replaceAll(";", "");
        return newString.trim();
    }

    private class ImageComparator
    implements Comparator<SeriesImageQueryResult> {
        private int preferredLangu = 0;
        private int english = 0;

        private ImageComparator(String language) {
            for (Language lang : TheTvDbMetadataProvider.this.tvdbLanguages) {
                if (language.equals(lang.abbreviation)) {
                    this.preferredLangu = lang.id;
                }
                if (!"en".equals(lang.abbreviation)) continue;
                this.english = lang.id;
            }
        }

        @Override
        public int compare(SeriesImageQueryResult arg0, SeriesImageQueryResult arg1) {
            if (arg0.languageId == this.preferredLangu && arg1.languageId != this.preferredLangu) {
                return -1;
            }
            if (arg0.languageId != this.preferredLangu && arg1.languageId == this.preferredLangu) {
                return 1;
            }
            if (arg0.languageId == this.english && arg1.languageId != this.english) {
                return -1;
            }
            if (arg0.languageId != this.english && arg1.languageId == this.english) {
                return 1;
            }
            int result = Double.compare(arg1.ratingsInfo.average, arg0.ratingsInfo.average);
            if (result == 0) {
                result = Integer.compare(arg1.ratingsInfo.count, arg0.ratingsInfo.count);
            }
            if (result == 0) {
                result = Integer.compare(arg1.id, arg0.id);
            }
            return result;
        }
    }
}

